package com.rocogz.merchant.dto.scm.order;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.sun.org.apache.bcel.internal.generic.RETURN;
import lombok.Getter;
import lombok.Setter;

/**
 * 搜索结算订单参数Dto
 * @author zhangmin
 */
@Setter @Getter
public class ScmSearchSettleOrderParamDto {

    /**
     * 收款单号
     */
    private String receiptCode;

    /**
     * 收款明细编号
     */
    private String receiptItemCode;

    /**
     * 发放会员手机号
     */
    private String grantMobile;

    /**
     * 分页
     */
    private Integer limit = 10;

    /**
     * 当前第几页
     */
    private Integer page = 1;

    /**
     * 是否需要导出
     */
    private Boolean export = Boolean.FALSE;


    @JsonIgnore
    public String getLikeGrantMobile() {
        if (StringUtils.isBlank(grantMobile)) {
            return null;
        }

        return "%" + grantMobile + "%";
    }

}
