package com.rocogz.merchant.dto.scmWarehouse.inside;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Map;
import java.util.Set;

/**
 * <dl>
 * <dd>Description:库存检查的视图 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class MerchantScmBodyGoodsStockViewDto {

    /**
     * 仓库编号
     */
    private String whCode;

    /**
     * 产品编号
     */
    private String whGoodsCode;

    /**
     * 需要的库存
     */
    private int needStock;

    /**
     * 仓库中的剩余库存
     */
    private int leftStock;

    /**
     * 合作客户产品编号
     */
    private  String customerGoodsCode;

    /**
     * 库存是否OK
     * @return
     */
    public boolean isOK(){
        if(this.leftStock<this.needStock){
            return false;
        }
        return true;
    }

}
