package com.rocogz.merchant.entity.scm;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <p>
 * 供应链下游订单结算金额详情
 * </p>
 *
 * @author zhangmin
 * @since 2021-07-29
 */
@Setter
@Getter
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
public class MerchantScmOrderSettle extends IdEntity {

    /**
     * 下游订单号
     *
     * @see MerchantScmOrderInformation#orderCode
     */
    private String orderCode;

    /**
     * 收款单号
     */
    private String receiptCode;

    /**
     * 收款单明细编号
     */
    private String receiptItemCode;

    /**
     * 结算金额
     */
    private BigDecimal settledAmount;

    /**
     * 收款单的 收款到账日期
     */
    private LocalDate receiptDate;

}
