package com.rocogz.merchant.entity.scmWarehouse;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.constant.ScmWarehouseConstant;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description:分销的库存 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmStock extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 仓库编号
     */
    private String whCode ;

    /**
     * 仓库名称
     */
    @TableField(exist = false)
    private String whName;

    /**
     * 仓库类型：主体，合作客户，服务商，平台仓
     * @see ScmWarehouseConstant.DictScmWarehouseType#TYPE_CODE
     */
    private String whType ;

    /**
     * 仓库类型名称
     */
    @TableField(exist = false)
    private String whTypeName;

    /**
     * 发放主体名称
     */
    @TableField(exist = false)
    private String issuingBodyName;

    /**
     * 主体code
     */
    private String issuingBodyCode;

    /**
     * 合作客户code
     */
    private String customerCode;

    /**
     * 合作客户名称
     */
    @TableField(exist = false)
    private String customerName;

    /**
     * 服务商编号
     */
    private String agentCode;

    /**
     * 服务商名称
     */
    @TableField(exist = false)
    private String agentName;

    /**
     * 产品存储的商品编号：合作客户产品编号/服务商产品编号/平台产品编号
     */
    private String goodsCode;

    /**
     * 产品存储的商品编号：合作客户产品编号/服务商产品编号/平台产品编号 对应的产品名称
     * 场景：在调拨，出入库回显时 有两个：仓库产品名称，仓库产品编号
     */
    @TableField(exist = false)
    private String goodsName;

    /**
     * 已入库总的良品库存
     */
    private Integer stock;

    /**
     * 冻结库存
     */
    private Integer frozenStock;

    /**
     * 占用库存
     */
    private Integer occupiedStock;

    /**
     * 预警库存
     */
    private Integer warnStock;

    /**
     * 销售的库存
     */
    private Integer saleStock;


    /**
     * 可售良品库存=stock-frozenStock-occupiedStock-saleStock
     */
    @TableField(exist = false)
    private Integer sellableStock;

    /**
     * 可售卖库存
     * @return
     */
    public Integer getSellableStock(){

      Integer leftStock=this.stock-this.frozenStock-this.occupiedStock- this.saleStock;

      return leftStock<=0?0:leftStock;
    }

}
