package com.rocogz.merchant.client.store;

import com.rocogz.syy.common.request.PageRequestParameter;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 商户参数
 * @author：liangyongtong
 * @since：2020/12/30
 */
@Setter
@Getter
@Accessors(chain = true)
public class ReqStore extends PageRequestParameter {
    /** 商户编码 */
    private String storeCode;

    /**
     * 关键字
     */
    private String keyword;

    /**
     * 类型编码
     */
    private String type;

    /**
     * 品牌编码
     */
    private String branchCode;

    /**
     * 省
     */
    private String provinceCode;
    /**
     * 市
     */
    private String cityCode;
    private String cityName;
    /**
     * 区
     */
    private String districtCode;
    /**
     * 街道
     */
    private String streetCode;

    /**
     * 营业状态
     */
    private String businessStatus;
    /**
     * 商户状态
     */
    private String status;

    /**
     * 商户编码列表
     */
    private List<String> storeCodes;

    /**
     * 行业编码
     */
    private String industryCode;

    /** 礼包系数 */
    private BigDecimal coefficient;

    /** 商户账号 */
    private String storeAccount;

    /**
     * 用户编码
     */
    private String userCode;

    /**
     * 标签列表
     */
    private List<String> labels;

    /**
     * 油品牌标签
     */
    private List<String> oilBrandLabelList;

    /**
     * 油站距离
     */
    private Integer distance;

    private String lng;
    private String lat;
}
