package com.rocogz.merchant.dto.customer.goods;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * <dl>
 * <dd>Description:主体产品的检查请求
 * 场景：可发放产品加上了stock_sno与库存关联，
 * 检查添加新的可发放产品时平台产品启用了库存管理，但平台仓中没有此产品
 * 在添加时会设置默认仓库为平台仓
 * </dd>
 * <dd>@date: 2022/04/01</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class IssuingBodyCustomerGoodsStockCheckReq {

    /**
     * 发放主体编码
     */
    @NotBlank
    private String issuingBodyCode;

    /**
     * 合作客户名称
     */
    @NotBlank
    private String customerCode;


    private List<IssuingBodyCustomerGoodsStockCheckItem> customerGoodsCodeList;


}
