package com.rocogz.merchant.dto.scm.oil;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 油卡充值结果实体类
 * @author djt
 * @date 2021/3/9
 */
@Data
public class RechargeResult {

    /**
     * 下单返回状态
     */
    private Boolean rechargeSuccess;

    /**
     * 下单返回code
     */
    private Integer code;

    /**
     * 下单返回消息
     */
    private String message;

    /**
     * 大和或者二运订单状态
     */
    private String status;

    /**
     *  对应分销系统明细订单状态
     */
    private String orderItemStatus;

    /**
     * 明细订单编号
     */
    private String orderItemCode;

    /**
     * 第三方订单编号
     */
    private String thirdOrderNo;

    /**
     * 供应链订单状态
     */
    private String thirdStatus;

    /**
     * 中石化券码(大和或者二运返回券码)
     */
    private String couponNo;

    /**
     * 上游备付金支付
     */
    private BigDecimal payAmount;

    /**
     * 有效期-开始时间
     */
    private String startTime;

    /**
     * 有效期-到期时间
     */
    private String endTime;

    /**
     * 备注
     */
    private String remark;


}
