package com.rocogz.merchant.dto.scm.order;

import com.rocogz.merchant.constant.Constant;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 撤回需要信息
 * @author：liangyongtong
 * @since：2021/4/26
 */
@Data
@Accessors(chain = true)
public class RecallInfoDto implements Serializable {

    /**
     * 下游订单编码
     */
    private String orderCode;

    /**
     * 下游订单类型
     * @see Constant.DictData#SCM_ORDER_TYPE_SYS
     */
    private String orderType;

    /**
     * 撤回的产品类型
     * @see Constant.DictData#PRODUCT_TYPE_FIXED_ELECTRIC
     */
    private String productType;

    /**
     * 清单编号（业务单号）
     */
    private String businessCode;

    /**
     * 用户券编号列表
     */
    private List<String> userCouponCodes;


    /**
     * 上游订单编号
     */
    private List<String> scmOrderItemCodes;


    /**
     * 是否是电卡订单
     * @return
     */
    public boolean isElectricOrder() {
        return Constant.DictData.PRODUCT_TYPE_FIXED_ELECTRIC.equalsIgnoreCase(productType)
                ||  Constant.DictData.PRODUCT_TYPE_FLEXIBLE_ELECTRIC.equalsIgnoreCase(productType);
    }

}
