package com.rocogz.merchant.dto.scm.order;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.entity.scm.MerchantScmOrderInformation;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangmin
 * 每个收款单的处理结果
 */
@Setter @Getter @Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ReceiptItemSettleResult extends SettleReceiptItem {

    /**
     * 已结算下游订单数量
     */
    private Integer settledOrderNum = 0;


    /**
     * 收款单已结算金额
     */
    private  BigDecimal settledAmount = BigDecimal.ZERO;

    /**
     * 结算的下游订单列表
     */
    private List<SettledScmOrder> settledOrderList;


    /**
     *  收款单盈余金额
     */
    public BigDecimal getSurplusAmount() {
        if(getTotalAmount() == null) {
            return BigDecimal.ZERO;
        }

        return getTotalAmount().subtract(settledAmount).setScale(3,RoundingMode.HALF_UP);
    }


    public  BigDecimal getSettledAmount() {
        return settledAmount.setScale(3,RoundingMode.HALF_UP);
    }


    public void addSettledScmOrder(SettledScmOrder settledOrder) {
        if(settledOrder == null) {
            return;
        }

        if(settledOrderList == null) {
            settledOrderList = new ArrayList<>();
        }
        settledOrderList.add(settledOrder);

        settledAmount = settledAmount.add(settledOrder.getOrderSettledAmount());

        settledOrderNum++;
    }


    @Setter @Getter @Accessors(chain = true)
    @NoArgsConstructor @AllArgsConstructor
    public static class SettledScmOrder {

        /**
         * 下游订单号
         * @see MerchantScmOrderInformation#orderCode
         */
        private String orderCode;

        /**
         * 本下游订单结算了多少钱
         */
        private BigDecimal orderSettledAmount;
    }

}
