package com.rocogz.merchant.dto.scmWarehouse.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:库存的调拨编辑请求</dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmGoodsStockAllocateEditReq {

    /**
     * 调拨申请单号
     */
    private String code;

    /**
     * 出库仓库编号
     */
    private String outWhCode;

    /**
     * 入库仓库编号
     */
    private String inWhCode;

    /**
     * 入库商品编号
     */
    private String inGoodsCode;

    /**
     * 出库商品编号
     */
    private String outGoodsCode;

    /**
     * 操作的数量
     */
    private Integer quantity ;

    /**
     * 备注
     */
    private String remark;

    /**
     * 操作人
     */
    private String operator;
    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
