package com.rocogz.merchant.dto.scmWarehouse.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:库存出库请求 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmGoodsStockOutReq {

    /**
     * 操作人人
     */
    @NotBlank
    private String operator;

    /**
     * 出库的产品列表
     */
    @Valid
    @NotEmpty
    private List<ScmGoodsStockOutItemDto> goodsList;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
