package com.rocogz.merchant.dto.scmWarehouse.stock;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.constant.ScmWarehouseConstant;
import com.rocogz.merchant.entity.scmWarehouse.MerchantScmStock;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:库存搜索的列表响应数据 </dd>
 * <dd>@date: 2022/03/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ScmStockExtendDto extends MerchantScmStock {


    /**
     * 在列表中查看详情时用的是Id
     */
    private Integer customerGoodsId;

    /**
     * 合作客户产品编号
     */
    private String customerGoodsCode;

    /**
     * 合作客户产品名称
     */
    private String customerGoodsName;

    /**
     * 服务商产品编号
     */
    private String agentGoodsCode;

    /**
     * 服务商产品名称
     */
    private String agentGoodsName;

    /**
     * 平台产品编号
     */
    private String platformGoodsCode;

    /**
     * 平台产品名称
     */
    private String platformGoodsName;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 供应商编码
     */
    private String supplierName;

    /**
     * 供应商产品编号
     */
    private String supplierGoodsCode;

    /**
     * 供应商产品名称
     */
    private String supplierGoodsName;

    /**
     * 列表图片
     */
    private String listView;


    /**
     * 平台产品采购价
     */
    private BigDecimal costPrice;

    /**
     * 平台产品市场价/面额
     */
    private BigDecimal marketPrice;


    /**
     * 代理商采购结算单价 ,代理商产品表中的purchaseSettlePrice
     */
    private BigDecimal agentPurchaseSettlePrice;

    /**
     * 代理商市场价/面额 ,代理商产品表中的marketPrice
     */
    private BigDecimal agentMarketPrice;

    /**
     * 合作客户 采购结算单价 合作客户产品表中的PurchaseSettlePrice
     */
    private BigDecimal customerPurchaseSettlePrice;

    /**
     * 合作客户 市场价/面额 合作客户产品表中的marketPrice
     */
    private BigDecimal customerMarketPrice;



    /**
     * 产品类别(本来这个是产品类型,后来牛哥说把这个改为产品类别,新加了一个产品类型,在下面用GoodsTypeCode表示)
     *
     * 关联字典：PLATEFORM_GOODS_TYPE
     *
     */
    private String goodsType;

    /**
     * 产品类别名称
     */
    private String goodsTypeName;


    /**
     * 产品类型code
     * 关联：MerchantProductType
     */
    private String goodsTypeCode;
    /**
     * 产品类型Name
     */
    private String goodsTypeCodeName;

    /**
     * 产品分类编码
     * 关联：MerchantGoodsClassification
     */
    private String goodsClassificationCode;

    /**
     * 产品分类
     */
    private String goodsClassificationCodeName;

    /**
     * 产品性质 关联字典：GOODS_NATURE
     */
    private String goodsNature;

    /**
     * 产品性质名称
     */
    private String goodsNatureName;

    /**
     * 品牌编码 关联：MerchantBrand
     */
    private String brandCode;

    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 合作客户产品状态
     */
    private String customerGoodsStatus;

    /**
     * 代理商产品状态
     */
    private String agentGoodsStatus;

    /**
     * 平台产品状态
     */
    private String platformGoodsStatus;

    /**
     * 合作产品创建时间
     */
    private LocalDateTime customerGoodsCreateTime;

    /**
     * 代理商产品创建时间
     */
    private LocalDateTime agentGoodsCreateTime;


    /**
     * 平台产品创建时间
     */
    private LocalDateTime platformGoodsCreateTime;


    /**
     * 场景：发放主体可发放产品配置仓库进行回显示前端列表是否默认选中
     */
    public boolean checked;






}
