package com.rocogz.merchant.dto.scmWarehouse.stock;

import com.rocogz.merchant.constant.ScmWarehouseConstant;
import lombok.Data;

import java.util.List;

/**
 * <dl>
 * <dd>Description:库存的分页请求 </dd>
 * <dd>@date: 2022/03/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class ScmStockSearchReq {

    /**
     * 仓库编号
     */
    private String whCode;

    /**
     * 仓库名称
     */
    private String whName;

    /**
     * 查询的仓库类型
     * @see ScmWarehouseConstant.DictScmWarehouseType#TYPE_CODE
     */
    private String whType;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 合作客户编号
     */
    private String customerCode;

    /**
     * 代理商编号
     */
    private String agentCode;




    /**
     * 平台产品编码
     */
    private String platformGoodsCode;

    /**
     * 平台产品状态
     */
    private String platformGoodsStatus;

    /**
     * 平台产品名称
     */
    private String platformGoodsName;



    /**
     * 代理商产品编码
     */
    private String agentGoodsCode;

    /**
     * 服务商产品状态
     */
    private String agentGoodsStatus;

    /**
     * 服务商产品名称
     */
    private String agentGoodsName;


    /**
     * 合作客户产品编码
     */
    private String customerGoodsCode;

    /**
     * 合作客户产品编码
     */
    private String customerGoodsStatus;

    /**
     * 合作客户产品编码
     */
    private String customerGoodsName;


    /**
     * 产品分类编码
     */
    private String goodsClassificationCode;

    /**
     * 品牌编号
     */
    private String brandCode;

    /**
     * 产品类型code
     */
    private String goodsTypeCode;

    /**
     * 过滤掉的goodsCode，针对数据库中goods_code字段进行过滤
     */
    private List<String> excludeGoodsCodes;
    /**
     * true 过滤出库存大于0的产品
     */
    private Boolean filterGreaterZeroStock;

    /**
     * 分页
     */
    private Integer limit = 20;
    /**
     * 当前第几页
     */
    private Integer page = 1;

    /**
     * 排序字段
     */
    private String sortField;

    /**
     * 排序方式：asc 正序 desc 倒序
     */
    private String sortType;

    /**
     * True 表示不分页时，分页条件不启作用
     */
    private Boolean noPage = Boolean.FALSE;

}
