package com.rocogz.merchant.entity.store;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.dto.common.KeyAndValue;
import com.rocogz.merchant.entity.attechment.MerchantAttechment;
import com.rocogz.merchant.entity.type.MerchantType;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 商户基本信息表
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStore extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商户编码
     */
    private String code;

    /**
     * 商户名称
     */
    private String name;

    /**
     * 商户简称
     */
    private String shortName;

    /**
     * 专区编码
     */
    @Deprecated
    private String areaCode;

    /**
     * 专区名称
     */
    @Deprecated
    private String areaName;

    @TableField(exist = false)
    private List<String> areaCodeList;

    @TableField(exist = false)
    private List<String> areaNameList;

    @Deprecated
    private String miniAppid;

    /**
     * 商户所属行业
     */
    private String industryCode;
    /**
     * 行业对象
     */
    @TableField(exist = false)
    private MerchantStoreIndustry industry;

    /**
     * 发放主体编号 通过合作客户服务项目 管理创建的不再填充这个值
     */
    private String issuingBodyCode;

    /**
     * 合作客户编号, 通过合作客户服务项目 如果没有商户，则会创建
     * 记录上商户所属的合作客户
     *
     */
    private String customerCode;

    /**
     * 合作客户简称
     */
    @TableField(exist = false)
    private String customerAbbreviation;

    /**
     * 发放主体名称
     */
    @TableField(exist = false)
    private String issuingBodyName;

    /**
     * 发放主体简称
     */
    @TableField(exist = false)
    private String issuingBodyShortName;

    /**
     * 商户所属结算商
     */
    @Deprecated
    private String settlementCode;

    /**
     * 结算信息
     */
    @TableField(exist = false)
    private MerchantStoreSettlement settlement;

    /**
     * 商户类型
     * @see MerchantType#code
     */
    private String type;


    /**
     * 商户类型对象
     */
    @TableField(exist = false)
    private MerchantType merchantType;

    /**
     * 商户状态
     */
    private String status;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区名称
     */
    private String districtName;

    /**
     * 区编码
     */
    private String districtCode;

    /**
     * 街道名称
     */
    private String streetName;

    /**
     * 街道编码
     */
    private String streetCode;

    /**
     * 详细地址
     */
    private String detailAddress;

    /**
     * 列表图:路径可能会被分割成几个对应比例的图
     */
    private String listView;

    /**
     * 详情图片列表
     */
    @TableField(exist = false)
    private List<MerchantAttechment> detailImages;

    /**
     * 商户介绍
     */
    private String introduce;

    /**
     * 定位来源区
     */
    private String locationDistrict;

    /**
     * 定位来源街道
     */
    private String locationStreet;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 定位来源市
     */
    private String locationCity;

    /**
     * 定位来源省
     */
    private String locationProvince;

    /**
     * 联系人
     */
    @TableField(exist = false)
    private List<MerchantStoreContacts> contacts;

    /**
     * 商户营业信息
     */
    @TableField(exist = false)
    private MerchantStoreBusiness business;

    /**
     * 停业信息
     */
    @TableField(exist = false)
    private List<MerchantStoreBusinessSection> sections;

    /**
     * 操作日志
     */
    @TableField(exist = false)
    private List<MerchantStoreUlog> uLogs;

    /**
     * 商户关联标签
     */
    @TableField(exist = false)
    private List<MerchantStoreLabel> labels;

    /**
     * 商户所属专区列表
     */
    @TableField(exist = false)
    private List<MerchantStoreArea> areaList;

    /**
     * 投保礼包系统
     */
    @Deprecated
    @TableField(exist = false)
    private MerchantStoreCoefficient coefficient;


    /**
     * 停业状态 Y/N
     */
    @TableField(exist = false)
    private String closed;

    /**
     * 营业状态 根据停业状态和营业时间计算
     */
    @TableField(exist = false)
    private boolean operatingState;

    /**
     * 营业时间和停业类型是否为空
     */
    @TableField(exist = false)
    private boolean empty = false;

    /**
     * 距离
     */
    @TableField(exist = false)
    private Integer distance;

    /**
     * 商户对应的评分数和订单数
     */
    @Deprecated
    @TableField(exist = false)
    private MerchantStoreKpi storeKpi;

    /**
     * 油站附加信息
     */
    @TableField(exist = false)
    private MerchantStoreOil oil;

    /**
     * 油站油品列表
     */
    @TableField(exist = false)
    private List<MerchantStoreOilType> oilTypes;

    @TableField(exist = false)
    private String qrCode;

    @TableField(exist = false)
    private String qrCodeSingle;

    @TableField(exist = false)
    private String qrCodeCompose;

    @TableField(exist = false)
    private List<KeyAndValue> keyAndValues;

    @TableField(exist = false)
    private List<MerchantStoreAreaLabel> areaLabelList;
}
