package com.rocogz.merchant.dto.scm;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2022-03-02 17:01</dd>
 * <dd>@author：yinshihao</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ReissueApplyQueryDto {
    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 申请类型(REISSUE:补发、DELAY_RECEIVE:领取有效期延期、DELAY_USE:使用有效期延期)
     */
    private String applyType;

    /**
     * 申请单状态(PENDING:待审批、PASS:审批通过、REFUSE:审批不通过、FAIL:处理失败、PART_FAIL:部分失败、PROCESSED:已处理)
     */
    private String status;

    /**
     * 申请人账号
     */
    private String applyUser;

    /**
     * 申请开始时间
     */
    private String applyTimeStart;

    /**
     * 申请结束时间
     */
    private String applyTimeEnd;

    /**
     * 新的下游订单编号
     */
    private String newDownOrderCode;

    /**
     * 发放会员手机号,收用户券的会员手机号
     */
    private String mobile;

    /**
     * 发放会员姓名
     */
    private String name;

    private Boolean export = false;
    private Integer page = 1;
    private Integer limit = 10;
}
