package com.rocogz.merchant.dto.scm.order;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.scm.MerchantScmInformation;
import com.rocogz.merchant.entity.scm.MerchantScmProductInformation;
import com.rocogz.merchant.entity.scm.MerchantScmTargetUser;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 撤回需要用到信息/校验是否能撤回用到的信息
 *
 * @author：liangyongtong
 * @since：2021/4/26
 */
@Data
@Accessors(chain = true)
public class RecallInfoDto implements Serializable {

    /**
     * 下游订单编码
     */
    private String orderCode;

    /**
     * 下游订单类型
     *
     * @see Constant.DictData#SCM_ORDER_TYPE_SYS
     */
    private String orderType;

    /**
     * 撤回的产品类型
     *
     * @see Constant.DictData#PRODUCT_TYPE_FIXED_ELECTRIC
     */
    private String productType;

    /**
     * 清单编号（业务单号）
     *
     * @see MerchantScmInformation#businessCode
     */
    private String businessCode;

    /**
     * 用户券编号列表
     * (1) 如果是撤回操作： 返回用户券发放状态等于成功的用户券
     * (2)如果是查询校验信息，用来校验是否能撤回，滴滴打车 则返回的是上游滴滴也是发券成功的Roco用户券
     */
    private List<String> userCouponCodes;


    /**
     * 上游订单编号列表
     */
    private List<String> scmOrderItemCodes;


    //===== 下单的字段 是撤销前校验是否能撤销 使用


    /**
     * 上游订单状态列表, 校验是否能撤回时 会用到该状态
     */
    private List<String> scmOrderItemStatusList;

    /**
     * 发放的目标用户手机号
     *
     * @see MerchantScmTargetUser#grantMobile
     */
    private String grantMobile;

    /**
     * 品牌编号
     *
     * @see MerchantScmProductInformation#brandCode
     */
    private String brandCode;

    /**
     * 下游订单状态
     */
    private String scmOrderStatus;


    /**
     * 是否是电卡订单
     *
     * @return
     */
    public boolean isElectricOrder() {
        return Constant.DictData.PRODUCT_TYPE_FIXED_ELECTRIC.equalsIgnoreCase(productType)
                || Constant.DictData.PRODUCT_TYPE_FLEXIBLE_ELECTRIC.equalsIgnoreCase(productType);
    }

}
