package com.rocogz.merchant.dto.scm.order;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.scm.MerchantScmInformation;
import com.rocogz.merchant.entity.scm.MerchantScmProductInformation;
import com.rocogz.merchant.entity.scm.MerchantScmTargetUser;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 撤回需要用到信息/校验是否能撤回用到的信息
 *
 * @author：liangyongtong
 * @since：2021/4/26
 */
@Data
@Accessors(chain = true)
public class RecallInfoDto implements Serializable {

    /**
     * 下游订单编码
     */
    private String orderCode;

    /**
     * 下游订单类型
     *
     * @see Constant.DictData#SCM_ORDER_TYPE_SYS
     */
    private String orderType;

    /**
     * 撤回的产品类型
     *
     * @see Constant.DictData#PRODUCT_TYPE_FIXED_ELECTRIC
     */
    private String productType;

    /**
     * 产品性质：单品还是套餐
     * @see Constant.DictData#GOODS_NATURE_ITEM
     * @see MerchantScmProductInformation#productNature
     */
    private String productNature;

    /**
     * 清单编号（业务单号）
     *
     * @see MerchantScmInformation#businessCode
     */
    private String businessCode;

    /**
     * 用户券编号列表
     * (1) 如果是撤回操作： 返回用户券发放状态等于成功的用户券
     */
    private List<String> userCouponCodes;



    //===== 下单的字段 是撤销前校验是否能撤销 使用


    /**
     * 滴滴打车 则返回的是上游滴滴也是发券成功的Roco用户券, 用来校验是否能撤回 (可能是平台自定义套餐中包含的滴滴券)
     */
    private List<String> didiRocoUserCouponCodes;

    /**
     * 该下游订单中：包含的电卡类型的上游订单，可能是套餐中包含的电卡
     */
    private List<RecallElectricScmOrderItem> electricItemList;

    /**
     * 发放的目标用户手机号
     *
     * @see MerchantScmTargetUser#grantMobile
     */
    private String grantMobile;

    /**
     * 整个下游订单 产品的 品牌编号
     *
     * @see MerchantScmProductInformation#brandCode
     */
    private String brandCode;

    /**
     * 下游订单状态
     */
    private String scmOrderStatus;


}
