package com.rocogz.merchant.dto.scmWarehouse.stock.pointExchange;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:库存冻结 </dd>
 * <dd>@date: 2022/03/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ScmPointExchangeGoodsStockFrozenReq {


    private String issuingBodyCode;

    /**
     * 操作账户编号
     */
    @NotBlank
    private String operator;

    /**
     * 冻结的产品列表
     */
    @Valid
    @NotEmpty
    private List<ScmPointExchangeGoodsStockFrozenItemDto> goodsList;

    /**
     * 操作时间
     */
    private LocalDateTime updateTime;

}
