package com.rocogz.merchant.dto.storeservice;

import lombok.Data;
import java.util.List;

/**
 * <dl>
 * <dd>Description:商户的分页查询 </dd>
 * <dd>@date: 2023/05/18</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class MerchantStorePageSearchDto {

    /**
     * 商户列表数据查询
     *
     * @param keyword        名称 模糊匹配
     * @param code           编码 全匹配
     * @param areaCodeList   专区编码 全匹配
     * @param industryCodeList   行业编码 全匹配
     * @param typeList           商户类型
     * @param status         商户状态
     * @param limit          每页条数
     * @param page           页码
     * @return
     */

    private String keyword;
    private String code;
    private String areaCodeList;
    private String industryCodeList;
    private String typeList;
    private String provinceCode;
    private String cityCode;
    private String districtCode;
    private String streetCode;
    private String businessStatus;
    private String status;
    private List<String> issuingBodyList;
    private int limit=20;
    private int page=2;

}
