package com.rocogz.merchant.entity.scm;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.agent.goods.MerchantAgentGoods;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.merchant.entity.customer.goods.MerchantCustomerGoods;
import com.rocogz.merchant.entity.goods.MerchantGoods;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 产品信息
 * </p>
 *
 * @author liangyongtong
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmProductInformation extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 合作客户产品编码
     *
     * @see MerchantCustomerGoods#code
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    private String customerProductName;

    /**
     * 客户产品类型：HAVE（门店自营）、PLATFORM（平台）
     *
     * @see MerchantCustomerGoods#customerGoodsType
     * @see Constant.General#MERCHANT_CUSTOMER_GOODS_HAVE
     */
    private String customerProductType;

    /**
     * 合作客户产品采购价格：用来扣减额度
     *
     * @see MerchantCustomerGoods#settlePrice
     */
    private BigDecimal customerPurchasePrice;

    /**
     * 合作客户产品市场价/面额
     *
     * @see MerchantCustomerGoods#marketPrice
     */
    private BigDecimal customerMarketPrice;

    /**
     * 合作客户结算采购价：用来扣减备付金
     *
     * @see MerchantCustomerGoods#purchaseSettlePrice
     */
    private BigDecimal customerPurchaseSettlePrice;

    /**
     * 代理商产品编码
     * 如果是 发放的服务项目客户产品则 没有服务商产品
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    private String agentProductName;

    /**
     * 代理商产品采购价格: 服务商产品额度扣减单价
     *
     * @see MerchantAgentGoods#purchasePrice
     */
    private BigDecimal agentPurchasePrice;

    /**
     * 代理商产品市场价/面额
     *
     * @see MerchantAgentGoods#marketPrice
     */
    private BigDecimal agentMarketPrice;

    /**
     * 代理商结算采购价
     *
     * @see MerchantAgentGoods#purchaseSettlePrice
     */
    private BigDecimal agentPurchaseSettlePrice;

    /**
     * 平台产品编码
     */
    private String productCode;

    /**
     * 平台产品名称
     */
    private String productName;

    /**
     * 产品性质: 单品, 供应商定制套餐、 平台定制套餐
     *
     * @see Constant.DictData#GOODS_NATURE_ITEM
     * @see MerchantGoods#goodsNature
     */
    private String productNature;

    /**
     * 平台供应商产品编码
     */
    @TableField(exist = false)
    private String thirdProductCode;

    /**
     * 平台采购价格
     *
     * @see MerchantGoods#costPrice
     */
    private BigDecimal purchasePrice;

    /**
     * 平台市场价/面额
     *
     * @see MerchantGoods#marketPrice
     */
    private BigDecimal marketPrice;

    /**
     * 产品类别：加油代金券、电子油卡券直充、积分券
     *
     * @see Constant.DictData#PRODUCT_TYPE_OIL_CARD_DIGITAL_YES
     * @see MerchantGoods#goodsType
     */
    private String productType;

    /**
     * 产品使用规则:原基准券编号
     */
    private String couponCode;

    /**
     * 平台产品的品牌编号,发放的客户产品对应的平台产品的品牌, 如果是套餐产品，这是套餐产品的品牌
     * 滴滴打车：分后台发放和积分兑换2种,发放的是供应商套餐产品，1个供应商套餐产品对应滴滴的1个策略id，滴滴产品的上游触发模式是核销时发放,具体流程如下：<br/>
     * 1.  后台发放-> 创建清单 -> 创建供应链订单-> 支付额度，备付金-> 发放roco用户券 -> 到步骤3  <br/>
     * 2. 车主端积分兑换->创建积分兑换商品订单-> 创建供应链订单-> 支付额度/备付金（积分兑换的无需支付）-> 发放roco用户券-> 到步骤3 <br/>
     * 步骤3:  在车主端使用用户券（如果上游滴滴券已经发放，则跳转到滴滴页面直接使用）-> 还没有触发上游，则 此时调用上游 发放滴滴打车券（需判定上游触发模式必须是"核销时发放"）-> 滴滴打车券发放成功后-> 车主端才能跳转到滴滴页面
     *
     * @see MerchantGoods#brandCode
     * @see MerchantBrand#DIDI
     */
    private String brandCode;

    //不存在表中，列表上需要显示
    /**
     * 产品类型名字
     */
    @TableField(exist = false)
    private String goodsTypeName;

    /**
     * 使用有效期-结束日期 (天)
     *
     * @see MerchantGoods#useValidity
     */
    @TableField(exist = false)
    private Integer useValidity;

    /**
     * 是否需要调用权益系统发放用户券接口 (Y:是, N:否)
     */
    @TableField(exist = false)
    private String whetherNeedIssueCoupon;


    //获取客户或服务商的市场价格
    public BigDecimal getCustomerOrAgentMarketPrice() {
        if (StringUtils.isNotBlank(customerProductCode)) {
            return customerMarketPrice;
        }

        return agentMarketPrice;
    }


    /**
     * 是否是 供应商 套餐产品
     *
     * @return
     */
    @JsonIgnore
    public boolean isSupplierMeal() {

        List<String> mealProductTypes = new ArrayList();
        mealProductTypes.add(Constant.DictData.PRODUCT_TYPE_PACKAGE);

        return Constant.DictData.GOODS_NATURE_SUPPLIER_MEAL.equalsIgnoreCase(this.productNature) && mealProductTypes.contains(this.productType);
    }

}
