package com.rocogz.merchant.client.scm.intfc;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;

/**
 * @author yinshihao
 * @Description: 广东中石油发券请求参数
 * @Package com.rocogz.dto.dingju.response.token
 * @date 2022-08-01 10:36:17
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
public class DingjuOilGdzsyOrderReqDto extends BaseConfigReqDto {

    /**
     * 发券手机号
     */
    @NotEmpty(message = "发券手机号不可为空")
    private String mobile;

    /**
     * 商户订单号
     */
    @NotEmpty(message = "商户订单号不可为空")
    private String outOrderId;

    /**
     * 商品编码
     */
    @NotEmpty(message = "商品编码不可为空,鼎聚那边给的第三方商品编号, 3元油品测试券: face003")
    private String shortname;

    /**
     * 下单回调url
     */
    private String notifyUrl;

    /**
     * 使用回调url，如果不填写，默认用下单url回调
     */
    private String useNotifyUrl;
}
