package com.rocogz.merchant.entity.storeservice;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.areaservice.MerchantAreaService;
import com.rocogz.merchant.entity.attechment.MerchantAttechment;
import com.rocogz.merchant.entity.service.ServiceClassification;
import com.rocogz.merchant.entity.store.MerchantStore;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 商户服务项目
 *
 * 后期O2O改版时,删了不少东西
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreService extends UserTimeEntity {

    private static final long serialVersionUID = 1240955452340922355L;
    /**
     * 商户服务项目编码
     */
    private String code;

    /**
     * 商户服务项目名称
     */
    private String name;

    /**
     * 创建来源
     */
    private String source;

    /**
     * 商户服务项目简称
     */
    private String abbreviation;

    /**
     * 所属商户编码
     */
    private String storeCode;

    /**
     * 服务所属合作客户 通过合作客户服务项目 管理创建的会填充这个值
     */
    private String customerCode;

    /**
     * 通过合作客户服务项目 管理创建的 标记所属方:客户自营服务项目
     *
     * CUSTOMER_SELF 客户自营
     * @see Constant.MerchantStoreServiceBelong#CUSTOMER_SELF
     */
    private String belong;


    /**
     * 合作客户简称
     */
    @TableField(exist = false)
    private String customerAbbreviation;

    /**
     * 商户对象
     */
    @TableField(exist = false)
    private MerchantStore store;

    /**
     * 服务所属分类编码
     */
    @Deprecated
    private String cataCode;

    /**
     * 商户服务类型对象
     */
    @Deprecated
    @TableField(exist = false)
    private ServiceClassification cata;

    /**
     * 专区服务项目编号
     */
    @Deprecated
    private String areaServiceCode;

    /**
     * 专区服务项目对象
     */
    @Deprecated
    @TableField(exist = false)
    private MerchantAreaService areaService;

    /**
     * 结算方编码
     */
    @Deprecated
    private String settleCode;

    /**
     * 结算方名称
     */
    @Deprecated
    private String settleName;

    /**
     * 商户服务项目状态
     */
    private String status;

    /**
     * 服务详细
     */
    private String introduce;

    /**
     * 使用有效期
     * 客户自定义的服务项目会更新平台产品的使用有效期天
     */
    private Integer useValidity;

    /**
     * 服务亮点
     */
    private String lightSpot;

    /**
     * 服务图片地址
     */
    private String url;

    /**
     * 是否区分车型 Y/N（
     *
     * 10.20改版后没有车型，但是市场价，成本价还保存在 MerchantStoreServicePrice 中，
     * 为了兼容老数据，我们新的价格存储的时候还是 distinguish=N , 在前台需要价格的时候
     * 使用 distinguish=N ，MerchantStoreServicePrice的只会有一条
     * ）
     */
    private String distinguish;

    /**
     * 结算方式
     */
    @Deprecated
    private String settleWay;

    /**
     * 是否套餐 Y/N
     */
    @Deprecated
    private String combo;

    /**
     * 套餐列表
     */
    @Deprecated
    @TableField(exist = false)
    private List<MerchantStoreServiceComboRelate> relates;

    /**
     * 显示顺序
     */
    private Integer seq;

    /**
     * 预约状态
     */
    @Deprecated
    private String appointmentStatus;

    /**
     * 商户服务项目对应的价格
     */
    @TableField(exist = false)
    private List<MerchantStoreServicePrice> prices;

    /**
     * 服务标签列表
     */
    @TableField(exist = false)
    private List<MerchantStoreServiceLabelRelate> labels;

    /**
     * 商户服务项目对应的平均分、订单数
     */
    @Deprecated
    @TableField(exist = false)
    private MerchantStoreServiceKpi storeServiceKpi;

    /**
     * 预约数量
     */
    @Deprecated
    @TableField(exist = false)
    private List<MerchantStoreServiceAppointment> appointments;

    /**
     * 详情图片列表
     */
    @TableField(exist = false)
    private List<MerchantAttechment> detailImages;


}
