package com.rocogz.merchant.entity.channel.product;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 平台产品-通道产品配置表
 * </p>
 *
 * @author ranxiangfu
 * @since 2021-11-23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantGoodsChannelProductConfig extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 平台产品编号
     */
    private String goodsCode;

    /**
     * 通道产品编号
     */
    private String channelProductCode;

    /**
     * 是否是默认通道产品
     */
    private Boolean isDefaultChannelProduct;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 通道产品信息
     */
    @TableField(exist = false)
    private MerchantChannelProduct channelProduct;
}
