package com.rocogz.merchant.request.validity;

import com.rocogz.merchant.request.base.PageReq;
import lombok.Data;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotBlank;
import java.util.HashMap;
import java.util.Map;

/**
 * @author djt
 * @date 2021/11/17
 */
@Data
public class ProductRuleSearchReq extends PageReq {

    private String productCode;

    @NotBlank
    private String issuingBodyCode;

    private String productType;

    private String productName;

    public Map<String,Object> toMap(){
        Map<String, Object> map = new HashMap<>();
        map.put("issuingBodyCode",issuingBodyCode);
        if (StringUtils.hasLength(productCode)){
            map.put("productCode",productCode);
        }
        if (StringUtils.hasLength(productType)){
            map.put("productType",productType);
        }
        if (StringUtils.hasLength(productName)){
            map.put("productName","%"+productName+"%");
        }
        return map;
    }

}
