package com.rocogz.merchant.dto.customer.goods.workflow.apply;

import com.rocogz.merchant.enumerate.CustomerGoodsConfigNodeTypeEnum;
import com.rocogz.merchant.enumerate.IntoreApplyAffairTypeEnum;
import lombok.Getter;
import lombok.Setter;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023/7/20 20:57</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
public class GoodsInstoreApplyAffairSearchParamDto extends GoodsInstoreApplyQueryParamDto {

    /**
     * 事项类型
     */
    private IntoreApplyAffairTypeEnum affairType;

    /**
     * 登录的用户Id，即办理事项的人id
     */
    private Integer approveUserId;

    /**
     * 登录的用户名，即办理事项的人
     */
    private String approveUser;

    /**
     * 节点类型：审批、审核、复核（查询用）
     */

    private transient CustomerGoodsConfigNodeTypeEnum nodeType;

    /**
     * 节点状态
     *
     * @see com.rocogz.merchant.constant.Constant.GoodsInstoreApplyStatus
     */
    private transient String applyStatus;

    /**
     * 排序字段
     */
    private transient String orderByField;
}
