package com.rocogz.merchant.dto.customer.goods.workflow.apply;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.customer.workflow.apply.GoodsInstoreApplyAttach;
import com.rocogz.merchant.enumerate.CustomerGoodsConfigNodeTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 产品入库申请单审批参数</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023/7/19 19:11</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@Accessors(chain = true)
public class GoodsInstoreApplyApproveParamDto {

    /**
     * 申请编号，单条审批用
     */
    private String applyCode;

    /**
     * 页面传过来的审批节点编号，单条审批用
     */
    private String currentApproveNode;

    /**
     * 批量审批对象集合，批量审批用
     */
    private List<ApproveApplyEntity> applyEntities;

    /**
     * 审批类型: 审核、审批、复核
     *
     * @see CustomerGoodsConfigNodeTypeEnum
     */
    private CustomerGoodsConfigNodeTypeEnum approveNodeType;

    /**
     * 审批的节点编号
     */
    private String approveNodeCode;

    /**
     * 审批节点名称
     */
    private String approveNodeName;

    /**
     * 审批结果, 通过或不通过
     *
     * @see Constant.GoodsInstoreApplyApproveResult
     */
    private String result;

    /**
     * 批注
     */
    private String remark;


    /**
     * 审批人用户名
     */
    private String approverUser;

    /**
     * 审批人名字
     */
    private String approverName;

    /**
     * 审批人手机号
     */
    private String approverMobile;

    /**
     * 审批时间，也就是创建时间
     */
    private LocalDateTime approveTime;

    /**
     * 附件信息
     */
    private List<GoodsInstoreApplyAttach> attachList;

    @JsonIgnore
    private Boolean isBatchApprove;

    @Getter
    @Setter
    @NoArgsConstructor
    @AllArgsConstructor
    public static final class ApproveApplyEntity {
        /**
         * 申请编号
         */
        private String applyCode;

        /**
         * 页面传过来的审批节点编号
         */
        private String currentApproveNode;
    }
}
