package com.rocogz.merchant.dto.customer.goods.workflow.apply;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.cooperationCustomer.MerchantCooperationCustomer;
import com.rocogz.merchant.entity.goods.MerchantGoods;
import com.rocogz.merchant.entity.supplier.MerchantSupplier;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023/7/19 19:11</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
public class GoodsInstoreApplyQueryParamDto {

    /**
     * 申请单号
     */
    private String applyCode;

    /**
     * 申请单号集合
     */
    private List<String> applyCodes;

    /**
     * 申请批次号
     */
    private String batchCode;

    /**
     * 产品库，也叫产品库（即合作客户编码，多选）
     *
     * @see MerchantCooperationCustomer#getCode()
     */
    private List<String> customerCodes;

    /**
     * 所属供应商（多选）
     *
     * @see MerchantSupplier#getCode()
     */
    private List<String> supplierCodes;

    /**
     * 产品编码
     *
     * @see MerchantGoods#getCode()
     */
    private String goodsCode;

    /**
     * 产品简称
     *
     * @see MerchantGoods#getAbbreviation()
     */
    private String goodsAbbreviation;

    /**
     * erp编码
     *
     * @see MerchantGoods#getErpGoodsCode()
     */
    private String erpGoodsCode;

    /**
     * 产品类型
     *
     * @see MerchantGoods#getGoodsTypeCode()
     */
    private String goodsTypeCode;

    /**
     * 商品品牌
     *
     * @see MerchantGoods#getBrandCode()
     */
    private String goodsBrandCode;

    /**
     * 申请开始日期
     */
    private String applyStartDate;

    /**
     * 申请结束日期
     */
    private String applyEndDate;

    /**
     * 申请单状态
     *
     * @see Constant.GoodsInstoreApplyStatus
     */
    private String status;

    /**
     * 页数
     */
    private int page = 1;

    /**
     * 每页记录数
     */
    private int limit = 20;

}
