package com.rocogz.merchant.dto.goodsStock;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.time.LocalDateTime;

@Builder
@Data
public class OrderVCardResponseItem {
    /**
     * 商品编码
     */
    private String goodsCode;
    /**
     * 卡号
     */
    private String cardNo;

    /**
     * 卡密类型 类型  CARD("卡号密码"), PASSWORD("卡密"), EXCHANGE("兑换码");
     */
    private String cardType;
    /**
     * 卡密
     */
    private String cardPwd;

    /**
     * 有效期开始时间
     */
    private LocalDateTime effectStartDate;

    /**
     *有效期结束时间
     */
    private LocalDateTime effectEndDate;

    @Tolerate
    public OrderVCardResponseItem() {
    }

}