package com.rocogz.merchant.dto.issuingBody.customerGoods;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * <dl>
 * <dd>Description:发放主体产品查询请求DTO </dd>
 * <dd>@date: 2023/07/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class IssuingBodyGoodsQuery {

    /**
     * 发放主体产品配置模式
     * CUS_PRO_ITEM : 指定产品
     * 1.issuingBodyCode,customerCode 必传递，并且customerCode是当前主体关联的客户编号
     * CUS_POOL: 产品库
     * 1.issuingBodyCode 必传递，并且customerCode是多仓库当时选择的合作客户仓库
     */
    @NotBlank
    private String issuingBodyGoodsConfigModel;

    /**
     * 发放主体
     */
    @NotBlank
    private String issuingBodyCode;

    /**
     * 合作客户
     */
    private String customerCode;

    /**
     * 1. 如果是 CUS_PRO_ITEM 代表要查询: 主体产品状态，合作客户产品状态 都是UP_LIST
     * 2. 如果是 POOL_ITEM 代表要查询 : 合作客户产品状态 都是UP_LIST
     */
    private String status;

    /***
     * 额度账户的费用类型
     */
    private String acctFeelType;

    /**
     * 产品库类型 这个含义是要查询分仓SUB_WH,总仓T_WH，
     */
    private String proWhBelongType;

    /**
     * 合作客户产品
     */
    private String customerGoodsCode;

    /**
     * 合作客户产品列表
     */
    private List<String> customerGoodsCodeList;



    /*******************一些页面中的查询操作*****************/


    /**
     * 合作客户产品
     */
    private String customerGoodsName;

    /**
     * 产品性质
     */
    private String goodsNature;

    /**
     *产品类别
     * merchant_goods.goods_type
     */
    private List<String> excludeGoodsTypes;

    /**
     * 合作客户产品状态
     */
    private String customerGoodsStatus;

    /**
     * 发放主体产品状态 merchant_issuing_body_customer_goods.status
     */
    private String issuingBodyGoodsStatus;

    /**
     * 产品类别
     */
    private String goodsType;

    /**
     * 产品类型
     */
    private String goodsTypeCode;

    /**
     * 已知排序的属性
     * 1.issuingBodyDetailTab 发放主体详情页展示的产品
     * 2.singleKhGoodsPop 单客户弹窗
     */
    private String sortProp;

}
