package com.rocogz.merchant.dto.scm;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.dto.scm.order.TriggerWay;
import com.rocogz.merchant.entity.scm.MerchantScmInformation;
import com.rocogz.merchant.entity.scm.MerchantScmOrderComboDetail;
import com.rocogz.merchant.entity.scm.MerchantScmOrderDetail;
import com.rocogz.merchant.entity.scm.MerchantScmProductInformation;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhangmin
 * 调用roco车服生成用户券接口 msgDto
 */
@Setter @Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GrantUserCouponMsgDto {

    /**
     * 失败后是第几次尝试：第一次是调用是0
     */
    private Integer retryTimes;

    /**
     * 业务主单号
     */
    private String applyNo;

    /**
     * 业务单号/批量发券申请清单号
     *
     * @see MerchantScmInformation#businessCode
     */
    private String businessCode;

    /**
     * 明细订单号
     * @see MerchantScmOrderDetail#orderItemCode
     */
    private String orderItemCode;

    /**
     * 供应商套餐明细订单编号：三级订单编码
     * @see  MerchantScmOrderComboDetail#comboOrderItemCode
     */
    private String comboOrderItemCode;

    /**
     * 是否套餐
     */
    private Boolean isSuite;


    /**
     * 发放平台
     */
    private String grantPlatform;

    /**
     * 发放方式：BATCH-批量发放，INTERFACE-接口发放，MANUAL-手工发放
     * @see Constant.DictData#GRANT_WAY_BATCH
     */
    private String grantWay;

    /**
     * 面值
     * @see MerchantScmOrderDetail#detailPrice     发放的单品
     * @see MerchantScmOrderComboDetail#detailPrice 发放的供应商套餐
     */
    private BigDecimal faceValue;


    /**
     * 操作用户:发放主体登录账号用户名
     */
    private String operateUser;

    /**
     * 操作人手机号:即发放主体登录账号的手机号
     * @see MerchantScmInformation#createUserMobile
     */
    private String operateUserMobile;

    /**
     * 发放主体
     */
    private String source;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 使用有效期：生效日期:yyyy-MM-dd 00:00:00
     */
    private LocalDateTime effectiveDate;

    /**
     * 使用有效期：失效日期:yyyy-MM-dd 23:59:59
     */
    private LocalDateTime invalidDate;

    /**
     * 领取有效期：生效日期:yyyy-MM-dd 00:00:00
     */
    private LocalDateTime receiveEffectiveDate;

    /**
     * 领取有效期：失效日期:yyyy-MM-dd 23:59:59
     */
    private LocalDateTime receiveInvalidDate;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码明文
     */
    private String idCardExplicit;

    /**
     * 保单编号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     *车架号
     */
    private String vinNo;

    /**
     * 发券性质：BUSINESS_VERIFY:业务验证，NORMAL:正常发券
     */
    private String nature;

    /**
     * 套餐平台产品编码
     * (1)非套餐时,该字段 传入null
     *（2）套餐时，传入 com.rocogz.merchant.entity.scm.MerchantScmOrderComboDetail#comboProductCode
     * @see MerchantScmOrderComboDetail#comboProductCode
     */
    private String comboProductCode;

    /**
     * (1)非供应商套餐时：传入 平台产品编码
     * @see com.rocogz.merchant.entity.scm.MerchantScmOrderDetail#productCode
     * (2)供应商套餐时：传入 套餐明细产品编码
     * @see com.rocogz.merchant.entity.scm.MerchantScmOrderComboDetail#productCode
     */
    private String productCode;

    /**
     * 代理商产品编号
     */
    private String agentProductCode;

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 客户产品类型
     * @see MerchantScmProductInformation#customerProductType
     */
    private String customerProductType;

    /**
     * 发放规则编号
     */
    private String grantRuleCode;

    /**
     * 领取规则编号
     */
    private String receiveRuleCode;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放主体团队编码
     */
    private String teamCode;

    /**
     * 传入的最外层整个产品的产品类型
     * @see MerchantScmProductInformation#productType
     */
    private String productType;

    /**
     * 传入的最外层整个产品的产品性质
     * @see MerchantScmProductInformation#productNature
     */
    private String productNature;

    /**
     * 发放主体：代理商编号
     */
    private String agentCode;

    /**
     * 发放主体：合作客户编号
     */
    private String customerCode;

    /**
     * 平台产品的brandCode
     * 如果发放的是套餐，则需要取子产品的品牌,也就是 等于该对象的 productCode 的产品品牌
     */
    private String brandCode;


    // ===  壳牌加油 积分兑换商品订单 相关字段如下 start ==
    /**
     * 壳牌油站编号 【壳牌加油】
     * @see QiaoPaiOilStationInfo#stationCode
     */
    private String oilStation;

    /**
     * 壳牌油站名 【壳牌加油】
     */
    private String oilStationName;

    /**
     * 壳牌油枪编号 【壳牌加油】
     */
    private String oilGun;

    /**
     * 壳牌油枪名 【壳牌加油】
     */
    private String oilGunName;

    /**
     * 壳牌油品、油号的编号：例如：95【壳牌加油】
     */
    private String oilNo;

    /**
     * 壳牌油品/油号名称：例如：95#【壳牌加油】
     */
    private String oilNoName;

    /**
     * 壳牌油品单价【壳牌加油】
     */
    private BigDecimal oilUnitPrice;
    // ===  壳牌加油 积分兑换商品订单 end ==
}
