package com.rocogz.merchant.dto.scm;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.goods.MerchantGoodsValidityRule;
import com.rocogz.merchant.entity.scm.MerchantScmInformation;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 发放产品订单信息参数
 *
 * @author：liangyongtong
 * @since：2021/3/9
 */
@Data
@Accessors(chain = true)
public class ScmSendDto implements Serializable {
    private static final long serialVersionUID = 5154035306572354255L;
    /**
     * 发放主体编号
     */
    private String sourceCode;

    /**
     * 发放主体性质:CUSTOMER（客户）或AGENT(服务商)
     */
    private String sourceNature;

    /**
     * 发放客户:客户编号或服务商编号
     */
    private String sourceCustomer;

    /**
     * 发放主体：代理商编号
     */
    private String agentCode;

    /**
     * 发放主体：合作客户编号
     */
    private String customerCode;

    /**
     * 扣款账户
     */
    private String dedutionCustomerCode;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放目标小程序的平台code
     */
    private String targetPlatform;

    /**
     * 发放目标小程序ID
     */
    private String targetMiniAppid;

    /**
     * 发放的领取 有效期规则编码
     */
    private String validityRules;

    /**
     * 发放方式:后台批量发放/接口/手工发放
     */
    private String grantWay;


    /**
     * 发放来源平台:SYY
     */
    private String grantPlatform;

    /**
     * 申请单号
     * (1) 如果是发放的：  applyNo = com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApply#applyNo
     * (2) 如果是积分兑换的 applyNo= com.rocogz.syy.order.entity.orders.SaleOrder#orderCode  积分兑换的订单号
     *
     * @see MerchantScmInformation#applyNo
     */
    private String applyNo;

    /**
     * 下单业务号,清单编号:接口发放/后台批量发放
     * (1)如果是发放的：businessCode = com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApplyDetail#code 清单编号
     * (2)如果是积分兑换的：businessCode = com.rocogz.syy.order.entity.orders.SaleOrder#orderCode  积分兑换的订单号
     *
     * @see MerchantScmInformation#businessCode
     */
    private String businessCode;

    /**
     * 领取有效期：生效日期
     */
    private LocalDateTime receiveEffectiveDate;

    /**
     * 领取有效期：失效日期
     */
    private LocalDateTime receiveInvalidDate;

    /**
     * 领取验证规则编号,限制哪些手机号可以领取,例如：姓名:Y;车牌号后几位:7;手机号前几位:3;手机号后几位:4;
     */
    private String receiveRules;

    /**
     * 发放业务性质:正常发放(NORMAL) / 业务验证(BUSINESS_VERIFY)
     */
    private String grantNature;

    /**
     * 创建人:发放主体登录账号 用户名
     */
    private String createUser;

    /**
     * 发放用户手机号：即发放主体登录账号的手机号
     */
    private String createUserMobile;

    /**
     * 发放总张数
     */
    private Integer quantity;

    /**
     * 如果是直充产品， 则表示单位面额,1张券输入的自定义面额
     * 如果是非直充：   则是单个客户产品/服务商产品 的市场价
     * 如果是C_OIL订单 则此字段表示输入的充值金额rechargeAmount
     */
    private BigDecimal unitFaceValue;

    /**
     * C端壳牌加油,则是选择的优惠抵扣金额
     */
    private BigDecimal discountAmount = BigDecimal.ZERO;

    /**
     * 合作客户产品编码
     */
    private String customerProductCode;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 平台产品编码
     */
    private String productCode;

    /**
     * 产品使用规则:原基准券编号
     */
    private String couponCode;

    /**
     * 发放会员手机号,收用户券的会员手机号
     */
    private String grantMobile;

    /**
     * 发放会员证件信息
     */
    private String grantIdno;

    /**
     * 发放会员证件类型
     */
    private String grantIdtype;

    /**
     * 发放会员车牌
     */
    private String grantLicence;

    /**
     * 发放会员车架号
     */
    private String vinNo;

    /**
     * 发放会员姓名
     */
    private String grantUsername;

    /**
     * 发放会员保单号
     */
    private String policyNumber;

    /**
     * 团队编码
     */
    private String teamCode;

    /**
     * 合作客户备付金扣减时点
     * @see com.rocogz.syy.settlement.entity.account.SettleAccountInfo#deductionTimeAppoint 主体额度账户信息中的扣减时点
     */
    private String dedutionTimePoint;

    /**
     * 订单类型
     *
     * @see Constant.DictData#SCM_ORDER_TYPE_SYS
     */
    private String orderType;

    /**
     * 额度支付金额
     */
    private BigDecimal quotaPrice = BigDecimal.ZERO;

    /**
     * 现在支付金额
     */
    private BigDecimal cashPrice = BigDecimal.ZERO;

    /**
     * 客户备付金扣减金额: 如果是纯现金支付的,客户服务商和服务商的备付金都是0
     */
    private BigDecimal coverPrice = BigDecimal.ZERO;

    /**
     * 服务商备付金扣款账户
     */
    private String deductionAgentCode;

    /**
     * 发放主体的：所属结算单位
     */
    private String belongSettlementUnit;


    /**
     * 为哪个上游订单补发【上游订单号】
     */
    private String reissueFor;

    /**
     * 补发金额
     */
    private BigDecimal reissuedAmount;


    /**
     * 仓库编号，如果发放的产品有 库存管理需求，则传入此字段
     */
    private String warehouseCode;


    // ===  壳牌加油 积分兑换商品订单 相关字段如下 ==
    /**
     * 壳牌油站编号 【壳牌加油】
     *
     * @see QiaoPaiOilStationInfo#stationCode
     */
    private String oilStation;

    /**
     * 壳牌油站名 【壳牌加油】
     */
    private String oilStationName;

    /**
     * 壳牌油枪编号 【壳牌加油】
     */
    private String oilGun;

    /**
     * 壳牌油枪名 【壳牌加油】
     */
    private String oilGunName;

    /**
     * 壳牌油品、油号的编号：例如：95【壳牌加油】
     */
    private String oilNo;

    /**
     * 壳牌油品/油号名称：例如：95#【壳牌加油】
     */
    private String oilNoName;

    /**
     * 壳牌油品单价【壳牌加油】
     */
    private BigDecimal oilUnitPrice;

    // ===  壳牌加油 积分兑换商品订单 end ==


    /**
     * 使用有效期规则 ,如果传入了规则则 使用传入的， 否则供应链端自己查询
     */
    private MerchantGoodsValidityRule validityRule;



    // =============下面是 浙商银行业务相关字段  ===========

    /**
     * 额度扣款 个人额度账户 【浙商银行业务字段】
     * @see EquityBatchDistributionCouponApplyDetail#deductionPersonAccountNo
     */
    private String deductionPersonAccountNo;

    /**
     * 额度扣款: 主体额度账户 【浙商银行业务字段】
     * @see EquityBatchDistributionCouponApplyDetail#deductionIssuingAccountNo
     */
    private String deductionIssuingAccountNo;

    /**
     * 主体业务类型 【浙商银行业务字段】
     * @see EquityBatchDistributionCouponApplyDetail#issuingBodyBusinessType
     */
    private String issuingBodyBusinessType;

    /**
     * 费用类型 【浙商银行业务字段】
     * @see EquityBatchDistributionCouponApplyDetail#feeType
     */
    private String feeType;



    /**
     * 是否需要支付合作客户备付金
     *
     * @return true:需要支付 ,false:不需要支付
     */
    public boolean needCustomerPay() {
        return StringUtils.isNotBlank(this.dedutionCustomerCode);
    }

    //获取发放的目标产品，如果客户产品不为空，则返回客户产品，否则返回服务产品
    public String getGrantProductCode() {
        if (StringUtils.isNotBlank(customerProductCode)) {
            return customerProductCode;
        }
        return agentProductCode;
    }


    //供应链下单，幂等 redisKey
    @JsonIgnore
    public String getIdempotentRedisKey() {

        StringBuilder buf = new StringBuilder();

        if (StringUtils.isNotBlank(businessCode)) {
            buf.append(businessCode).append(":");
        }

        if (StringUtils.isNotBlank(sourceCustomer)) {
            buf.append(sourceCustomer).append(":");
        }

        if (StringUtils.isNotBlank(grantMobile)) {
            buf.append(grantMobile).append(":");
        }

        if (StringUtils.isNotBlank(productCode)) {
            buf.append(productCode).append(":");
        }

        if (StringUtils.isNotBlank(sourceCode)) {
            buf.append(sourceCode);
        }

        // String idempotenceKey = businessCode + ":" + sourceCustomer + ":" + grantMobile + ":" + productCode + ":" + sourceCode;
        String idempotenceKey = buf.toString();
        return idempotenceKey;
    }

}
