package com.rocogz.merchant.entity.areaservice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 专区服务项目结算价
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantAreaServiceSettlementPrice extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 结算编码
     */
    private String settlementCode;

    /**
     * 车型Key
     */
    private String modelKey;

    /**
     * 车型Name
     */
    private String modelName;

    /**
     * 结算价
     */
    private BigDecimal price;

}
