package com.rocogz.merchant.entity.club;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Description: 会所菜品表
 * @date：2022/09/23
 * @author：陈煜敏
 */
@Data
@Accessors(chain = true)
@TableName("merchant_club_dishes")
@EqualsAndHashCode(callSuper = true)
public class MerchantClubDishes extends UserTimeEntity {

    /**
     * 菜品编码(序列号,自动生成)
     */
    private String code;

    /**
     * 菜品名称
     */
    private String name;

    /**
     * 发放主体编码
     */
    private String issuingBodyCode;

    /**
     * 菜品单价
     */
    private BigDecimal price;

    /**
     * 是否上架(DOWN_LIST:下架，UP_LIST:上架)
     *
     * @see Constant#COMMON_FLAG_UP_LIST
     * @see Constant#COMMON_FLAG_DOWN_LIST
     */
    private String status;

    /**
     * 是否删除(0:正常，1:删除)
     */
    private Boolean delFlag;

}