package com.rocogz.merchant.entity.electric.southern;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * 南网渠道商充值卡信息
 */
@EqualsAndHashCode(callSuper = true)
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
@Accessors(chain = true)
@TableName("merchant_electric_recharge_card")
public class MerchantElectricRechargeCard extends IdEntity {

    /**
     * 批次ID
     */
    private String batchId;

    /**
     * 充值卡ID
     */
    private String rechargeId;

    /**
     * 充值卡类型
     */
    private String rechargeType;

    /**
     * 充值卡名称
     */
    private String rechargeName;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}