package com.rocogz.merchant.entity.electric.southern;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 南网渠道商充值卡所属批次信息
 */
@EqualsAndHashCode(callSuper = true)
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
@Accessors(chain = true)
@TableName("merchant_electric_recharge_card_batch")
public class MerchantElectricRechargeCardBatch extends IdEntity {

    /**
     * 扣款主体编号
     */
    private String deductSubjectCode;

    /**
     * 扣款主体名称
     */
    @TableField(exist = false)
    private String deductSubjectName;

    /**
     * 批次ID
     */
    private String batchId;

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 南网批次发卡额度
     */
    private BigDecimal batchHairpinQuota;

    /**
     * 南网批次可用余额
     */
    private BigDecimal balanceHairpin;

    /**
     * 批次可用额度
     * 这个是车服自己记录的，不是从南网查询
     */
    private BigDecimal availableQuota;

    /**
     * 批次已使用额度
     * 这个是车服自己记录的，不是从南网查询
     */
    private BigDecimal usedQuota;

    /**
     * 过期退款金额
     * 这个是车服自己记录的，不是从南网查询
     */
    private BigDecimal expireQuota;

    /**
     * 生效时间
     */
    private LocalDate effectiveDate;

    /**
     * 失效时间
     */
    private LocalDate invalidDate;

    /**
     * 发卡开始时间
     */
    private LocalDate hairpinStartTime;

    /**
     * 发卡截止时间
     */
    private LocalDate hairpinEndTime;

    /**
     * 最近同步时间
     */
    private LocalDateTime lastSyncTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 充值卡信息
     */
    @TableField(exist = false)
    private List<MerchantElectricRechargeCard> rechargeCardList;


    public void substractBalance(BigDecimal decrementAmt) {
        if (availableQuota == null) {
            return;
        }

        availableQuota = availableQuota.subtract(decrementAmt);
    }


}