package com.rocogz.merchant.entity.insuranceGift;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 
 * </p>
 *
 * @author yifenrui
 * @since 2020-09-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("merchant_insurance_gift_comb_relate")
public class MerchantInsuranceGiftCombRelate extends UserTimeEntity {


    /**
     * 组合套餐code
     */
    private String giftCode;

    /**
     * 关联服务项目code
     */
    private String relateCode;

    /**
     * 服务数量
     */
    private Integer number;

    /**
     * 排序
     */
    private String sort;



    /**
     * 商户服务项目名称
     */
    @TableField(exist = false)
    private String packageName;


    /**
     * 服务所属分类编码
     */
    @TableField(exist = false)
    private String cataCode;

    /**
     * 服务所属分类名称
     */
    @TableField(exist = false)
    private String cataName;


    /**
     * 服务状态
     */
    @TableField(exist = false)
    private String serviceStatus;

    /**
     * 项目数量
     */
    @TableField(exist = false)
    private Integer projectNum;


    /**
     * 市场价
     */
    @TableField(exist = false)
    private BigDecimal marketPrice;

    /**
     * 成本价
     */
    @TableField(exist = false)
    private BigDecimal costPrice;

    /**
     * 销售价
     */
    @TableField(exist = false)
    private BigDecimal settlePrice;



}
