package com.rocogz.merchant.entity.scm;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.dto.scm.ScmSendDto;
import com.rocogz.merchant.entity.cooperationCustomer.MerchantCooperationCustomer;
import com.rocogz.merchant.entity.customer.goods.MerchantCustomerGoods;
import com.rocogz.merchant.entity.exchangeGoodsPoints.MerchantExchangeGoodsPoints;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 供应链发放信息
 * </p>
 *
 * @author liangyongtong
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmInformation extends UserTimeEntity {

    private static final long serialVersionUID = 6368647649044093889L;

    /**
     * 供应链下游订单号
     */
    private String orderCode;

    /**
     * 发放主体编号
     * @see com.rocogz.syy.equity.entity.issuingBody.IssuingBody#code
     */
    private String sourceCode;

    /**
     * 发放主体性质,即发放主体类型：是代理商(AGENT) 还是合作客户(CUSTOMER)
     *
     * 如果是积分兑换的 sourceNature=AGENT
     * @see Constant.DictData#SOURCE_NATURE_AGENT
     * @see com.rocogz.syy.equity.entity.issuingBody.IssuingBody#whetherCustomer
     */
    private String sourceNature;

    /**
     * 发放客户：
     * (1) 如果sourceNature=AGENT,    则是代理商编号 AGE00002021
     * (2) 如果sourceNature=CUSTOMER, 则是合作客户编号 CTR00002030
     */
    private String sourceCustomer;

    /**
     * 发放主体：代理商编号
     * (1) 如果sourceNature=AGENT,则等于sourceCustomer
     * （2）如果sourceNature=CUSTOMER，则等于合作客户上的agentCode
     *   @see MerchantCooperationCustomer#agentCode
     */
    private String agentCode;

    /**
     * 发放主体：合作客户编号
     * (1) 积分兑换：该字段为空
     * (2)sourceNature = AGENT，该字段为空
     * (2)sourceNature = CUSTOMER，该字段为发放主体上的客户编号
     * @see com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApply#customerCode
     * @see com.rocogz.syy.equity.entity.issuingBody.IssuingBody#customerCode
     */
    private String customerCode;

    /**
     * 扣款 合作客户编号或代理商编号
     * 发放申请单创建人主体对应的合作客户编号或代理商编号
     * （1）积分兑换：该字段为空
     */
    private String dedutionCustomerCode;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放用户手机号：即发放主体 登录账号的手机号
     */
    private String createUserMobile;


    /**
     * 发放目标平台,微信小程序的servicePlatformCode
     * @see com.rocogz.syy.infrastructure.entity.app.config.BasicWxMiniAppConfig#servicePlatformCode
     */
    private String targetPlatform;

    /**
     * 发放目标小程序ID
     */
    private String targetMiniAppid;

    /**
     * 领取有效期规则编码,也就是发放规则编号
     * @see com.rocogz.syy.equity.entity.rule.EquityInssuingRule#code
     */
    private String validityRules;

    /**
     * 发放方式:
     * (1)后台批量发放
     * /接口/
     *(2)手工发放:包括B端礼赠申请单
     *(3)积分兑换
     * @see Constant.DictData#GRANT_WAY_BATCH
     */
    private String grantWay;

    /**
     * 发放来源平台：SYY
     */
    private String grantPlatform;

    /**
     * 原始发放张数: 清单中的quantity
     * @see com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApplyDetail#getQuantity
     */
    private Integer quantity;

    /**
     1. 如果是发放的（包括：后台发放/单客户发券/B端小程序礼赠）
     （1）如果是非固定面额产品(油卡直充 或 非固定面额电卡 或 积分) unitFaceValue = 输入的自定义面额
     （2）其他类型产品：unitFaceValue = 客户产品产品的市场价 {@link MerchantCustomerGoods#marketPrice}
     2. 如果是积分兑换的：
     （1）非固定面额产品(油卡直充或非固定面额电卡)：unitFaceValue = 输入的自定义面额
      (2)兑换的其他类型： unitFaceValue = 积分产品的市场价 {@link MerchantExchangeGoodsPoints.marketPrice}
     * @see ScmSendDto#unitFaceValue
     */
    private BigDecimal unitFaceValue;

    /**
     * C端壳牌加油,则是选择的优惠抵扣金额
     * @see ScmSendDto#discountAmount
     */
    private BigDecimal discountAmount;

    /**
     * 发放申请单号
     * (1)如果是发放的：  applyNo = com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApply#applyNo
     * (2)如果是积分兑换的 applyNo= com.rocogz.syy.order.entity.orders.SaleOrder#orderCode  积分兑换的订单号
     * (3)川分员工之家领取审核活动 applyNo= com.rocogz.syy.activity.entity.reo.receive.ActivityReceiveAuditJoinRecordGift#joinCode 活动参与记录编号
     */
    private String applyNo;

    /**
     * 下单业务号：即清单编号:接口发放/后台批量发放
     * @see com.rocogz.syy.equity.entity.userCoupon.EquityUserCouponLaunchInfo#applyDetailCode 发放用户券时设置到发放信息的applyDetailCode
     *
     *(1)如果是发放的：businessCode = com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApplyDetail#code 清单编号
     *(2)如果是积分兑换的：businessCode = com.rocogz.syy.order.entity.orders.SaleOrder#orderCode  积分兑换的订单号
     *(3)川分员工之家领取审核活动参与记录 businessCode= com.rocogz.syy.activity.entity.reo.receive.ActivityReceiveAuditJoinRecordGift#businessCode
     */
    private String businessCode;

    /**
     * 领取有效期：生效日期
     */
    private LocalDateTime effectiveDate;

    /**
     * 领取有效期：失效日期
     */
    private LocalDateTime invalidDate;

    /**
     * 领取有效期状态：(未生效, 已生效、已过期)
     * @see  Constant.DictValidityStatus#INEFFECTIVE
     */
    private String receiveValidityStatus;

    /**
     * 已延期次数
     */
    private Integer  deferCnt;

    /**
     * 领取验证规则
     */
    private String receiveRules;

    /**
     * 发放业务性质:正常发放/业务验证
     * @see com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApply#nature
     */
    private String grantNature;

    /**
     * 发放主体团队编码
     * @see basic_team_info.team_code
     */
    private String teamCode;

    /**
     * 服务商备付金扣款账户
     */
    private  String deductionAgentCode;

    /**
     * 发放主体的：所属结算单位
     */
    private String belongSettlementUnit;


    /**
     * 额度扣款 个人额度账户 【浙商银行业务字段】
     * @see EquityBatchDistributionCouponApplyDetail#deductionPersonAccountNo
     */
    private String deductionPersonAccountNo;

    /**
     * 额度扣款: 主体额度账户 【浙商银行业务字段】
     * @see EquityBatchDistributionCouponApplyDetail#deductionIssuingAccountNo
     */
    private String deductionIssuingAccountNo;

    /**
     * 主体业务类型编号 【浙商银行业务字段】
     * @see EquityBatchDistributionCouponApplyDetail#issuingBodyBusinessType
     * @see basic_business_type#business_code
     */
    private String issuingBodyBusinessType;
    /**
     * 费用类型 【浙商银行业务字段】
     * @see EquityBatchDistributionCouponApplyDetail#feeType
     */
    private String feeType;


    //-----------传输---------
    //下游详情要用
    /**
     * 发放客户名称
     */
    @TableField(exist = false)
    private String sourceCustomerName;

    //下游订单类型,给权益基础服务使用
    @TableField(exist = false)
    private String orderType;

}
