package com.rocogz.merchant.entity.scm;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 处理下游订单支付信息临时表
 * </p>
 *
 * @author yinshihao
 * @since 2021-04-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "merchant_scm_order_in_tmp_0417")
public class OrderInTmp0417 extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 发放主体
     */
    private String sourceCode;

    /**
     * 团队编码
     */
    private String teamCode;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 支付状态
     */
    private String payStatus;

    /**
     * 支付金额
     */
    private BigDecimal payPrice;

    /**
     * 支付方式
     */
    private String payWay;

    /**
     * 支付次数
     */
    private Integer payRetryNum;

    /**
     * 支付时间
     */
    private LocalDateTime payTime;

    /**
     * 领取额度状态，账户中领取额度是否已处理
     */
    private String receiveQuotaStatus;

    /**
     * 扣减结果
     */
    private String payResult;

    /**
     * 领取结果
     */
    private String receiveResult;

    private String payReason;

    private String recevieReason;


}
