package com.rocogz.merchant.client.customer;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 合作客户请求参数
 * @author：liangyongtong
 * @since：2021/2/1
 */
@Data
@Accessors(chain = true)
public class CooperationCustomerReq implements Serializable {
    /** 名称 */
    private String name;

    /**
     * 客户类别: 直营/代理商
     */
    private String customerCategory;

    /**
     * 是否排除查询联系人、行业等信息
     * 默认为false，不排除
     */
    private boolean isExcludeOtherInfo;

    /**
     * 是否隐藏代理商名称
     * 默认为false，不隐藏
     */
    private boolean isHideAgentName;

    /**
     * 合作客户编码列表，为null查全部
     */
    private List<String> customerCodeList;


    /**
     * 代理商数据权限，为null查全部
     */
    private List<String> agentDataPermissionList;

    /**
     * 合作客户数据权限，为null查全部
     */
    private List<String> customerDataPermissionList;

}
