package com.rocogz.merchant.dto.agent.goods;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * <dl>
 * <dd>Description:代理商产品上下架的状态请求 </dd>
 * <dd>@date: 2023/07/26</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class MerchantAgentGoodsStatusChangeReq {


    /**
     * 操作人ID
     */
    @NotNull
    private Integer userId;

    /**
     * 操作人用户名
     */
    @NotBlank
    private String operator;

    /**
     * 操作人姓名
     */
    @NotBlank
    private String operatorName;

    /**
     * 状态
     */
    @NotBlank
    private String status;

    /**
     * 产品ID
     */
    @NotEmpty
    private List<Integer> ids;
}
