package com.rocogz.merchant.dto.issuingBody.goodsConfigPool;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * <dl>
 * <dd>Description:主体产品池的保存请求 </dd>
 * <dd>@date: 2023/07/09</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class MerchantIssuingBodyGoodsPoolConfigSaveReq {

    /**
     * 发放主体
     */
    @NotBlank(message = "请传递发放主体")
    private String issuingBodyCode;

    /**
     * 操作人
     */
    @NotBlank(message = "请传递操作人")
    private String operator;

    /**
     * 保存的配置
     */
    private MerchantIssuingBodyGoodsPoolConfigSaveItemDto config;



}
