package com.rocogz.merchant.dto.scm;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * c端加油订单创建分销订单的请求实体类
 * @author djt
 * @date 2022/4/13
 */
@Data
@Accessors(chain = true)
public class ScmConsumerOilCreateOrderReq {

    @NotBlank
    private String customerProductCode;

    @NotBlank
    private String issuingBodyCode;

    /**
     * @see com.rocogz.syy.oilc.entity.OilcOrder#orderCode
     * C端加油订单编号
     */
    @NotBlank
    private String businessNo;

    /**
     * C端加油支付的现金金额
     * @see com.rocogz.syy.oilc.entity.OilcOrder#needPayTotalAmount
     */
    @NotNull
    private BigDecimal payCashAmount;

    /**
     * C端加油 输入的充值金额充值金额
     * @see com.rocogz.syy.oilc.entity.OilcOrder#rechargeAmount
     */
    private BigDecimal rechargeAmount;

    /**
     * 订单优惠金额，壳牌roco加油抵扣券抵扣的金额
     * @see com.rocogz.syy.oilc.entity.OilcOrder#discountAmount
     */
    private BigDecimal discountAmount;

    /**
     * C端加油充值手机号
     * @see com.rocogz.syy.oilc.entity.OilcOrder#rechargeMobile
     */
    @NotBlank
    private String rechargeMobile;

    /**
     *结算单元
     */
    private String settleUnit;

    /**
     * 发放主体所属合作客户编号
     */
    private String customerCode;

    /**
     * 发放主体代理商编号
     */
    private String agentCode;

    /**
     * 发放主体性质
     */
    private String issuingNature;



    /**
     * 发放目标平台编号
     * @see basicWxMiniAppConfig#servicePlatformCode
     */
    private String targetPlatform;

    /**
     * 目标平台miniAppId
     * @see basicWxMiniAppConfig#miniAppId
     */
    private String targetMiniAppid;


    /**
     * 领取规则编号
     * @see EquityReceiveRule#code
     */
    private String receiveRules;

    /**
     * 领取有效期：生效日期
     */
    private LocalDateTime receiveEffectiveDate;

    /**
     * 领取有效期：失效日期
     */
    private LocalDateTime receiveInvalidDate;

    /**
     * 领取有效期规则编号，即 发放规则的编号
     * @see EquityInssuingRule#code
     */
    private String  validityRules;

    /**
     * 发放平台
     * EquityConstants.PLATFORM_CODE_SYY
     */
    private String grantPlatform;


    /**
     * 基准券编号
     * @see  EquityCashCouponProduct#couponCode
     */
    private String couponCode;

    /**
     * 仓库编号
     */
    private String warehouseCode;


    // ===  壳牌加油 积分兑换商品订单 相关字段如下 ==
    /**
     * 壳牌油站编号 【壳牌加油】
     * @see QiaoPaiOilStationInfo#stationCode
     */
    private String oilStation;

    /**
     * 壳牌油站名 【壳牌加油】
     */
    private String oilStationName;

    /**
     * 壳牌油枪编号 【壳牌加油】
     */
    private String oilGun;

    /**
     * 壳牌油枪名 【壳牌加油】
     */
    private String oilGunName;

    /**
     * 壳牌油品、油号的编号：例如：95【壳牌加油】
     */
    private String oilNo;

    /**
     * 壳牌油品/油号名称：例如：95#【壳牌加油】
     */
    private String oilNoName;

    /**
     * 壳牌油品单价【壳牌加油】
     */
    private BigDecimal oilUnitPrice;

}
