package com.rocogz.merchant.dto.scm;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.scm.MerchantScmOrderDetail;
import com.rocogz.merchant.entity.scm.MerchantScmOrderInformation;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 过期退款的MQ消息DTO
 */
@Data
public class ScmExpiredRefundJmsDto {

    /**
     * 下游订单号
     * @see MerchantScmOrderDetail#orderCode
     */
    private String scmOrderCode;

    /**
     * 上游订单号
     * @see MerchantScmOrderDetail#orderItemCode
     */
    private String scmOrderItemCode;

    /**
     * 发放时间
     * @see MerchantScmOrderInformation#grantTime
     */
    private LocalDateTime grantTime;

    /**
     * 充值金额
     *  @see MerchantScmOrderDetail#detailPrice
     */
    private BigDecimal chargeAmt;

    /**
     * 平台产品采购价
     * @see MerchantScmOrderDetail#getPlatProdPurchasePrice()
     */
    private BigDecimal purchasePrice;

    /**
     * 结算扣款主体编号
     * @see MerchantScmOrderDetail#channelProductDeductSubjectCode
     */
    private String deductSubjectCode;

    /**
     * 产品类别,上游订单中的产品类型,该产品类型用来决定走不同的上游订单Handler处理器类，非常重要
     * (1) 如果是不是平台自定义套餐,productType = MerchantScmProductInformation#productType
     * (2) 如果是平台自定义套餐，则 productType = 自定义平台套餐中子产品的产品类型
     *
     * @see Constant.DictData#PRODUCT_TYPE_DRIVING_SERVICE
     */
    private String productType;


    /**
     * 重试次数
     */
    private int retryTimes;

    /**
     * 上次重试时间
     */
    private LocalDateTime lastRetryTime;

}
