package com.rocogz.merchant.dto.scm.oil;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 鼎聚统一下单接口直充回调实体
 * @author 陈煜敏
 * @date 2023/05/24
 */
@Data
public class DingJuCouponOrderDTO {

    /**
     * 平台订单号
     */
    private String tradeNo;

    /**
     * 商户订单号
     */
    private String outTradeNo;

    /**
     * 订单状态，详细参照附录1
     */
    private String orderState;

    /**
     * 下单时间
     */
    private String orderTime;

    /**
     * 权益名称
     */
    private String title;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 面额
     */
    private String faceValue;

    /**
     * 满减限制金额
     */
    private String availableValue;

    /**
     * 有效天数，0表示不限制
     */
    private String expireDays;

    /**
     * 有效开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime startTime;

    /**
     * 有效结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime endTime;

    private String sign;
    private String appid;
    private String time;

}
