package com.rocogz.merchant.dto.scm.order;


import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.customer.goods.MerchantCustomerGoods;
import com.rocogz.merchant.entity.scm.MerchantScmOrderInformation;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * <dl>
 * <dd>Description:下游订单的搜索条件 </dd>
 * <dd>@date: 2021/03/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode()
@Accessors(chain = true)
public class ScmAdminDownOrderSearchResponseDto {

    /**
     * 下游订单号
     */
    private String orderCode;

    /**
     * 发放主体名称，在聚合中查询一次
     */
    private String sourceName;

    /**
     * 发放客户名称
     */
    private String sourceCustomerName;

    /**
     * 发放方式
     */
    private String grantWayName;

    /**
     * 发放平台来源名称
     */
    private String grantPlatformName;

    /**
     * 发放目标平台名称
     */
    private String targetPlatformName;

    /**
     * 下单业务号
     */
    private String businessCode;

    /**
     * 发放会员手机号
     */
    private String grantMobile;

    /**
     * 证件类型名称
     */
    private String grantIdtypeName;

    /**
     * 发放会员证件信息
     */
    private String grantIdno;

    /**
     * 发放会员车牌
     */
    private String grantLicence;

    /**
     * 车架号
     */
    private String vinNo;

    /**
     * 发放会员姓名
     */
    private String grantUsername;

    /**
     * 发放会员保单号
     */
    private String policyNumber;

    /**
     * 真实会员手机号
     */
    private String realMobile;
    /**
     * 领取验证状态
     */
    private String receiveValidateStatus;

    /**
     * 领取时间
     */
    private String strReceiveValidateTime;

    /**
     * 合作客户产品编码
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    private String customerProductName;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    private String agentProductName;

    /**
     * 平台产品编码
     */
    private String productCode;

    /**
     * 平台名称
     */
    private String productName;

    /**
     * 产品类别名字，在聚合后台进行查询
     */
    private String productTypeName;

    /**
     * 产品类型名字
     */
    private String goodsTypeName;

    /**
     * 合作客户专享价
     */
    private BigDecimal customerPurchasePrice;
    /**
     * 合作客户产品市场价/面额
     */
    private BigDecimal customerMarketPrice;

    /**
     * 代理商采购价
     */
    private BigDecimal agentPurchasePrice;

    /**
     * 代理商产品市场价/面额
     */
    private BigDecimal agentMarketPrice;

    /**
     * 平台产品采购价格
     */
    private BigDecimal purchasePrice;

    /**
     * 平台产品市场价/面额
     */
    private BigDecimal marketPrice;

    /**
     * 发放总张数
     */
    private Integer quantity;

    /**
     * 合作客户专享价合计
     */
    private String customerPurchasePriceTotal;
    /**
     * 合作客户产品市场价/面额合计
     */
    private String customerMarketPriceTotal;

    /**
     * 代理商采购价合计
     */
    private String agentPurchasePriceTotal;

    /**
     * 代理商产品市场价/面额合计
     */
    private String agentMarketPriceTotal;

    /**
     * 平台采购价合计
     */
    private String purchasePriceTotal;

    /**
     * 平台市场价/面额合计
     */
    private String marketPriceTotal;

    /**
     * 订单总金额/商品总面值
     */
    private BigDecimal totalPrice;

    /**
     * 发放成功张数（权益用户券的数量)
     */
    private Integer quantitySuccess;

    /**
     * 明细订单记录数量
     */
    private Integer secondOrderNum;

    /**
     * 下单时间
     */
    private String strOrderTime;

    /**
     * 发放时间
     */
    private String strGrantTime;

    /**
     * 发放时间
     */
    private String strGrantSuccessTime;
    /**
     * 下油订单状态
     */
    private String strOrderStatus;

    /**
     * 支付时间
     */
    private String strPayTime;


    /**
     * 额度退款时间
     */
    private String strRefundTime;

    /**
     * 撤回时间
     */
    private String strRecallTime;


    //忽略
    /**
     * 发放主体性质
     */

    private String sourceNature;

    /**
     * 领取验证时间
     */

    private LocalDateTime receiveValidateTime;

    /**
     * 发放客户
     */

    private String sourceCustomer;

    /**
     * 发放方式
     */

    private String grantWay;

    /**
     * 发放平台来源
     */

    private String grantPlatform;

    /**
     * 发放目标平台
     */

    private String targetPlatform;

    /**
     * 发放目标平台小程序ID
     */
    private String targetMiniAppid;

    /**
     * 发放目标平台小程序Name
     */
    private String targetMiniAppidName;

    /**
     * 发放会员证件类型
     */

    private String grantIdtype;

    /**
     * 发放主体
     */

    private String sourceCode;

    /**
     * 下单时间
     */
    private LocalDateTime orderTime;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放成功时间
     */

    private LocalDateTime grantSuccessTime;

    /**
     * 产品类别
     * @see Constant.DictData#PRODUCT_TYPE_OIL_CARD_DIGITAL_YES
     */

    private String productType;

    private String orderStatus;

    /**
     * 发券性质
     */
    private String grantNature;

    //下游订单退的是额度
    /**
     * 发券性质名称
     */
    private String grantNatureName;

    /**
     * 客户备付金扣减时点
     * @see MerchantScmOrderInformation#dedutionTimePoint
     */
    private String dedutionTimePoint;

    /**
     * 客户备付金扣减时点
     */
    private String dedutionTimePointName;


    /**
     * 是否需要扣减客户的备付金,Y/N add by zhangmin at 2023-07-10【浙商银行需求 新增加的字段】
     * 如果客户产品不需要扣减客户的备付金, 则把 dedutionTimePoint设置为NO_DEDUCTION
     *
     * @see Constant.DictData#COMMON_STATUS_YES
     * @see MerchantCustomerGoods#needProvisions
     */
    private String whetherDeductCustomerCover;

    /**
     * 支付状态
     * @see Constant.DictData#SCM_PAY_STATUS_UNPAID
     */
    private String payStatus;

    /**
     * 支付状态名称
     */
    private String payStatusName;

    /**
     * 支付金额
     */
    private BigDecimal payPrice;

    /**
     * 支付方式
     * @see Constant.DictData#SCM_PAY_WAY
     */
    private String payWay;

    /**
     * 支付方式名称
     */
    private String payWayName;

    /**
     * 支付次数
     */
    private Integer payRetryNum;

    /**
     * 支付结果提示
     */
    private String payReason;

    /**
     * 支付时间
     */
    private LocalDateTime payTime;


    /**
     * 额度退款状态
     */
    private String quotaRefundStatus;

    /**
     * 额度退款状态名称
     */
    private String quotaRefundStatusName;

    /**
     * 额度退款金额
     */
    private BigDecimal quotaRefundPrice;


    /**
     * 额度退款时间
     */
    private LocalDateTime refundTime;

    /**
     * 撤回时间
     */
    private LocalDateTime recallTime;


    /**
     * 额度支付金额
     */
    private BigDecimal payQuotaPrice;

    /**
     * 现金支付金额
     */
    private BigDecimal payCashPrice;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 订单类型名称
     */
    private String orderTypeName;


    /**
     * 合作客户结算采购价
     */
    private BigDecimal customerPurchaseSettlePrice;


    /**
     * 代理商结算采购价
     */
    private BigDecimal agentPurchaseSettlePrice;


    /**
     * 平台产品采购价合计
     */
    private String customerPurchaseSettlePriceTotal;

    /**
     * 代理商结算采购价合计
     */
    private String agentPurchaseSettlePriceTotal;

    /**
     * 服务商备付金支付总金额
     */
    private BigDecimal agentPayPrice;

    /**
     * 服务商备付金支付状态
     */
    private String agentPayStatus;

    /**
     * 服务商备付金支付状态名称
     */
    private String agentPayStatusName;

    /**
     * 服务商备付金支付时间
     */
    private LocalDateTime  agentPayTime;

    /**
     * 服务商备付金支付次数
     */
    private Integer agentPayRetryNum;

    /**
     * 服务商备付金扣减时点
     */
    private String agentDeductionTime;

    /**
     * 服务商备付金扣减时点中文
     */
    private String agentDeductionTimeName;

    /**
     * 服务商备付金退款状态
     */
    private String agentRefundStatus;

    /**
     * 服务商备付金退款状态中文名称
     */
    private String agentRefundStatusName;

    /**
     * 服务商备付金退款金额
     */
    private BigDecimal agentRefundPrice;

    /**
     * 服务商备付金退款时间
     */
    private LocalDateTime agentRefundTime;

    /**
     * 结算状态
     */
    private String settleStatus;

    /**
     * 状态对应的中文名称
     */
    private String settleStatusName;

    /**
     * 结算完成时间
     */
    private LocalDateTime settleTime;

    /**
     * 所属结算单元
     */
    private String belongSettlementUnit;

    /**
     * 所属结算单元
     */
    private String belongSettlementUnitName;


    /**
     * 合作客户备付金支付金额
     */
    private BigDecimal customerPayPrice;

    /**
     * 合作客户备付金支付状态
     */
    private String customerPayStatus;

    /**
     * 合作客户备付金支付状态中文名
     */
    private String customerPayStatusName;

    /**
     * 合作客户备付金支付时间
     */
    private LocalDateTime customerPayTime;

    /**
     * 合作客户备付金支付流水
     */
    private String customerPayFlow;

    /**
     * 合作客户备付金支付次数
     */
    private Integer customerPayRetryNum;

    /**
     * 合作客户备付金退款价格
     */
    private BigDecimal customerRefundPrice;

    /**
     * 合作客户备付金退款状态
     */
    private String customerRefundStatus;


    /**
     * 合作客户备付金退款状态中文名
     */
    private String customerRefundStatusName;


    /**
     * 合作客户备付金退款时间
     */
    private LocalDateTime customerRefundTime;

    /**
     * 合作客户备付金退款流水
     */
    private String customerRefundFlow;

}
