package com.rocogz.merchant.dto.scm.qiaopai.req;

import com.rocogz.merchant.client.scm.intfc.BaseConfigReqDto;
import com.rocogz.merchant.entity.scm.MerchantScmOrderDetail;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 供应链系统发放壳牌油卡请求实体
 * @author yinshiaho
 * @date 2022/7/30
 */
@Data
public class QiaoPaiOilRechargeRequest extends BaseConfigReqDto {

    /**
     * 订单号
     * @see MerchantScmOrderDetail#orderItemCode
     */
    @NotBlank(message = "订单号不能为空")
    private String merchantOrderNo;

    /**
     * 油站编码
     */
    @NotBlank(message = "油站编码不能为空")
    private String stationCode;

    /**
     * 渠道优惠总金额
     */
    @NotNull(message = "渠道优惠总金额不能为空")
    private BigDecimal channelFavourAmount;

    /**
     * 订单总金额
     */
    @NotNull(message = "订单总金额不能为空")
    private BigDecimal amount;

    /**
     * 油品编码
     */
    @NotBlank(message = "油品编码不能为空")
    private String code;

    /**
     * 油枪
     */
    @NotBlank(message = "油枪不能为空")
    private String oilGun;

    /**
     * 产品编号
     */
    @NotBlank(message = "产品编号不能为空")
    private String goodsCode;

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    private String phone;

    /**
     * 充值成功回调地址
     */
    private String callbackUrl;

    /**
     * 退款成功回调地址
     */
    private String refundCallbackUrl;

    /**
     *
     */
    private String ext;
}
