package com.rocogz.merchant.dto.storeservice.issuingBody;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:发放主体发放项目管理的列表Dto </dd>
 * <dd>@date: 2022/12/02</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class IssuingBodyStoreServiceGoodsListDto {

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 发放主体简称
     */
    private String issuingBodyAbbreviation;

    /**
     * 所属合作客户
     */
    private String customerCode;

    /**
     * 合作客户简称
     */
    private String customerAbbreviation;

    /**
     * 合作客户产品
     */
    private String customerGoodsCode;

    /**
     * 服务项目编号
     */
    private String serviceCode ;

    /**
     * 服务项目名称
     */
    private String serviceName;

    /**
     * 服务项目简称
     */
    private String serviceAbbreviation;

    /**
     * 服务项目标签
     */
    private String serviceLabel;

    /**
     * 成本价，重写组装的
     */
    private BigDecimal serviceSettlePrice;

    /**
     * 市场价 , 重写组装的
     */
    private BigDecimal serviceMarketPrice;

    /**
     * 使用有效期天
     */
    private Integer useValidity;

    /**
     * 添加人-添加到主体中人
     */
    private String issuingBodyGoodsCreateUser;

    /**
     * 添加时间 - 添加到主体中的添加时间
     */
    private LocalDateTime issuingBodyGoodsCreateTime;

    /**
     * 添加人-添加到主体中更新时间
     */
    private String issuingBodyGoodsUpdateUser;

    /**
     * 添加时间 - 添加到主体中更新时间
     */
    private LocalDateTime issuingBodyGoodsUpdateTime;

    /**
     * 服务项目状态
     */
    private String serviceStatus;

    /**
     * 主体项目状态: 主体产品的上下架状态
     */
    private String issuingBodyGoodsStatus;



}
