package com.rocogz.merchant.entity.club;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @Description: 会所包房表
 * @date：2022/09/23
 * @author：陈煜敏
 */
@Data
@Accessors(chain = true)
@TableName("merchant_club_room")
@EqualsAndHashCode(callSuper = true)
public class MerchantClubRoom extends UserTimeEntity {

    /**
     * 包房编码(序列号,自动生成)
     */
    private String code;

    /**
     * 包房名称
     */
    private String name;

    /**
     * 发放主体编码
     */
    private String issuingBodyCode;

    /**
     * 包房图片地址
     */
    private String imageUrl;

    /**
     * 包房人数
     */
    private Integer diningNum;

    /**
     * 是否启用(LOCK:停用，OPEN:启用)
     *
     * @see Constant.DictData#COMMON_STATUS_OPEN
     * @see Constant.DictData#COMMON_STATUS_LOCK
     */
    private String status;

    /**
     * 是否占用(DEFAULT:未占用，IN_USED:占用)
     *
     * @see Constant.ClubRoomUsedStatus
     */
    private String usedStatus;

    /**
     * 是否删除(0:正常，1:删除)
     */
    private Boolean delFlag;

}