package com.rocogz.merchant.entity.customer.workflow.apply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.cooperationCustomer.MerchantCooperationCustomer;
import com.rocogz.merchant.entity.goods.MerchantGoods;
import com.rocogz.merchant.entity.supplier.MerchantSupplier;
import com.rocogz.merchant.enumerate.CustomerGoodsConfigNodeTypeEnum;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023/7/19 16:28</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("merchant_customer_goods_instore_apply")
public class GoodsInstoreApply extends UserTimeEntity {

    /**
     * 申请单编码
     */
    private String code;

    /**
     * 申请批次号
     */
    private String batchCode;

    /**
     * 机构编码，即合作客户编码
     */
    private String customerCode;

    /**
     * 机构信息，即合作客户信息（也叫产品库）
     */
    @TableField(exist = false)
    private MerchantCooperationCustomer customer;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 所属供应商
     */
    @TableField(exist = false)
    private MerchantSupplier supplier;

    /**
     * 产品编号
     */
    private String goodsCode;

    /**
     * 平台产品信息
     */
    @TableField(exist = false)
    private MerchantGoods goods;

    /**
     * 采购结算单价
     */
    private BigDecimal quotaPurchaseUnitPrice;

    /**
     * 申请单状态
     *
     * @see Constant.GoodsInstoreApplyStatus
     */
    private String status;

    /**
     * 申请人用户名 : reference basic_system_admin_user.username
     */
    private String applierUser;

    /**
     * 申请人用户id : reference basic_system_admin_user.id
     */
    private Integer applierUserId;

    /**
     * 申请人手机号 : reference basic_system_admin_user.mobile
     */
    private String applierMobile;

    /**
     * 申请人名字 : reference basic_system_admin_user.name
     */
    private String applierName;

    /**
     * 最近一次审批节点编号（上级审批节点编号）
     */
    private String lastApproveNodeCode;

    /**
     * 最近一次审批节点名称（上级审批节点名称）
     */
    private String lastApproveNodeName;

    /**
     * 最近一次审批节点类型（上级审批节点类型）
     */
    private CustomerGoodsConfigNodeTypeEnum lastApproveNodeType;

    /**
     * 最近一次审批结果，通过，不通过（上级审批结果）
     *
     * @see Constant.GoodsInstoreApplyApproveResult
     */
    private String lastApproveResult;

    /**
     * 最近一次审批时间（上级审批时间）
     */
    private LocalDateTime lastApproveTime;

    /**
     * 审批进度：当前审批节点节点类型，审批/审核/复核
     * 之所以不用枚举类型，是因为审批通过之后需要将这个字段置为空，使用mybatis-plus更新会默认忽略为null的属性
     *
     * @see CustomerGoodsConfigNodeTypeEnum#name()
     */
    private String curNodeType;

    /**
     * 当前节点编号(还未审)
     */
    private String curNodeCode;

    /**
     * 当前节点名称(还未审)
     */
    private String curNodeName;

    /**
     * 最近的操作: 如 审核、审批、处理
     * 只有申请单进行过审批操作，此字段才有值
     *
     * @see CustomerGoodsConfigNodeTypeEnum#name()
     */
    private String recentAction;

    /**
     * 最近操作时间：审批、审核、复核时间
     * 只有申请单进行过审批操作，此字段才有值
     */
    private LocalDateTime recentActionTime;

    /**
     * 最近操作人用户名
     * 只有申请单进行过审批操作，此字段才有值
     */
    private String recentActionUser;

    /**
     * 是否被逻辑删除
     */
    private boolean deleted;

    /**
     * 编辑申请时,是否是保存草稿,如果是保存草稿，就不启动工作流,申请单状态是DRAFT
     */
    @TableField(exist = false)
    private transient Boolean saveDraft;

    /**
     * 当前节点的审批人列表
     */
    @TableField(exist = false)
    private List<GoodsInstoreApplyRuntimeNodeApprover> currentApproves;

    /**
     * 申请流程
     */
    @TableField(exist = false)
    private List<GoodsInstoreApplyProgress> progress;

    /**
     * 操作人：操作人信息用来设置到时间线上
     */
    @TableField(exist = false)
    private GoodsInstoreApplyOperateUser operateUser;

    /**
     * 将当前节点的审批人列表拼接成字符串
     *
     * @return
     */
    @JsonProperty
    public String getCurrentApproverStr() {
        if (CollectionUtils.isNotEmpty(currentApproves)) {
            return currentApproves.stream().map(GoodsInstoreApplyRuntimeNodeApprover::getApproverName).collect(Collectors.joining("/"));
        }
        return StringUtils.EMPTY;
    }

    /**
     * 判断申请单是否可以进行审批、审核、复核操作
     *
     * @return
     */
    public boolean isApproveble() {
        return Constant.GoodsInstoreApplyStatus.PENDING_APPROVE.equals(status) ||
                Constant.GoodsInstoreApplyStatus.PENDING_AUDIT.equals(status) ||
                Constant.GoodsInstoreApplyStatus.PENDING_REVIEW.equals(status);
    }

    /**
     * 判断申请单是否是申请不通过状态
     *
     * @return
     */
    public boolean isRejected() {
        return Constant.GoodsInstoreApplyStatus.APPROVE_FAILED.equals(status) ||
                Constant.GoodsInstoreApplyStatus.AUDIT_FAILED.equals(status) ||
                Constant.GoodsInstoreApplyStatus.REVIEW_FAILED.equals(status);
    }

    /**
     * 判断申请单是否是申请通过状态
     *
     * @return
     */
    public boolean isPassed() {
        return Constant.GoodsInstoreApplyStatus.PASS.equals(status);
    }
}
