package com.rocogz.merchant.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 套餐商品
 * </p>
 *
 * @author yinshihao
 * @since 2021-01-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantGoodsMeal extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 平台商品编码,也就是套餐平台产品编号
     */
    private String goodsCode;

    /**
     * 套餐明细平台商品编码，也就是 套餐中的子产品编号
     */
    private String mealGoodsCode;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 数量
     */
    private Integer sum;

    /**
     * 商品名称
     */
    @TableField(exist = false)
    private String name;

    /**
     * 产品类型名称
     */
    @TableField(exist = false)
    private String goodsTypeName;

    /**
     * 产品分类名称
     */
    @TableField(exist = false)
    private String goodsClassificationName;

    /**
     * 状态
     */
    @TableField(exist = false)
    private String status;

    /**
     * 供应商产品编号
     */
    private String supplierGoodsCode;

    /**
     * 供应商产品名称
     */
    @TableField(exist = false)
    private String supplierGoodsName;

    /**
     * 图片
     */
    @TableField(exist = false)
    private String listView;

    /**
     * 卡券左上角标签
     */
    @TableField(exist = false)
    private String cardCouponLeftCornerLabel;

    /**
     * 卡券金额下方注释内容
     */
    @TableField(exist = false)
    private String cardCouponNotes;

    /**
     * 使用说明
     */
    @TableField(exist = false)
    private String introduce;

    /**
     * 产品类别 特别容易搞不清楚 这是产品类别
     * @see MerchantGoods#goodsType
     */
    @TableField(exist = false)
    private String goodsType;

    /**
     * 产品内容
     */
    @TableField(exist = false)
    private String goodsContent;

    
    /**
     * 商品平台产品的市场价
     */
    @TableField(exist = false)
    private BigDecimal merchantGoodsMarketPrice;


    /**
     * 一句话亮点，也就是列表中的权益说明
     * @see MerchantGoods#saleLightPoint
     */
    @TableField(exist = false)
    private String saleLightPoint;

    /**
     * 有效期，列表中有个有效期
     * @see MerchantGoods#useValidity
     */
    @TableField(exist = false)
    private Integer useValidity;

    /**
     * 左侧中部显示文案
     * @see MerchantGoods#leftMiddleDisplayDescribe
     */
    @TableField(exist = false)
    private String leftMiddleDisplayDescribe;

    /**
     * 产品性质 单品，平台订单套餐，供应商定制套餐
     */
    @TableField(exist = false)
    private String goodsNature;

    /**
     * 品牌名称
     */
    @TableField(exist = false)
    private String brandName;

    /**
     * 是否虚拟商品(Y:是,N:否)
     */
    @TableField(exist = false)
    private String invented;
}
